/*
 * Badari wrote this
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <fcntl.h>
#include <libaio.h>

#define NR      10
#define SZ      4096
#define QSZ     1024

io_context_t    io_ctx;

int
aio_setup()
{
	int ret;
	ret = io_queue_init(QSZ, &io_ctx);
	if (ret != 0) {
		fprintf(stderr, "aio_setup: io_queue_init failed: %s\n",
			strerror(ret));
		return(-1);
	}
	return(0);
}

int
aio_submit(struct iocb **iocbs)
{
	int ret;
	struct io_event event;
	static struct timespec ts;

	ts.tv_sec = 30; ts.tv_nsec = 0;
	ret = io_submit(io_ctx, NR, iocbs);
	if (ret != NR) {
		fprintf(stderr, "errcode=%d\n", ret);
		fprintf(stderr, "aio_submit: io_submit failed: %s\n",
			strerror(ret));
		return(-1);
	}
	ret = io_getevents(io_ctx, 1, NR, &event, &ts);
	if (ret != NR) {
		printf("errorcode =%d\n", ret);
		fprintf(stderr, "aio_submit: io_getevents failed: %s\n",
			strerror(ret));
		return(-1);
	}
	return 0;
}


int
main()
{
	int fd, i, pos;
	struct iocb *iocbs[NR];

	/* Initialize */
	pos=0;
	for (i = 0; i < NR; i++) {
		if ((iocbs[i] = malloc(sizeof(struct iocb))) == NULL) exit(1);
	}

	/* Setup */
	fd = open("raw1", O_RDWR|O_CREAT);
	if (aio_setup() != 0) exit(1);

	/* Bunch of writes */
	for (i = 0; i < NR; i++) {
		char *tbuf = (char *)valloc(SZ);
		memset((void *)tbuf, 'x', SZ);
		io_prep_pwrite(iocbs[i], fd, tbuf, SZ, pos);
	}

	/* Submit */
	if (aio_submit(iocbs) != 0)
		exit(1);
	exit(0);
}
