#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

char meg[1024*1024];
char *ourname;

static void doit(char *filename, unsigned long nmegs)
{
	int fd;
	int chunk = 1024 * 1024;

	fd = open(filename, O_RDWR|O_CREAT|O_TRUNC, 0666);
	if (fd < 0) {
		fprintf(stderr, "%s: cannot create %s: %s\n",
			ourname, filename, strerror(errno));
		exit(1);
	}

	while (nmegs--) {
		int remainder = 1024 * 1024;

		while (remainder) {
			int to_write = chunk;

			if (to_write > remainder)
				to_write = remainder;

			if (write(fd, meg, to_write) != to_write) {
				fprintf(stderr, "%s: short write\n", ourname);
			}
			remainder -= to_write;
		}
	}
	close(fd);
	unlink(filename);
}

int main(int argc, char *argv[])
{
	char *filename;
	unsigned long nmegs;
	int nreps;

	ourname = argv[0];

	if (argc != 4) {
		fprintf(stderr,
			"Usage: %s filename nmegs nreps\n",
			ourname);
		exit(1);
	}

	filename = argv[1];
	nmegs = atoi(argv[2]);
	nreps = atoi(argv[3]);

	while (nreps--)
		doit(filename, nmegs);
	exit(0);
}
