#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>

#include "syscalls.h"

char *progname;

static void usage(void)
{
	fprintf(stderr, "Usage: %s filename offset length [loops]\n", progname);
	exit(1);
}

int
main(int argc, char *argv[])
{
	int c;
	int fd;
	char *filename;
	loff_t offset;
	unsigned long length;
	long ret;
	int loops = 1;
	int loop_counter;

	progname = argv[0];

	while ((c = getopt(argc, argv, "")) != -1) {
		switch (c) {
		}
	}

	if (optind == argc)
		usage();
	filename = argv[optind++];

	if (optind == argc)
		usage();
	offset = strtoull(argv[optind++], NULL, 0);

	if (optind == argc)
		usage();
	length = strtol(argv[optind++], NULL, 0);

	if (optind != argc)
		loops = strtol(argv[optind++], NULL, 0);

	if (optind != argc)
		usage();

	fd = open(filename, O_RDONLY);
	if (fd < 0) {
		fprintf(stderr, "%s: cannot open `%s': %s\n",
			progname, filename, strerror(errno));
		exit(1);
	}

	loop_counter = loops;
	while (loop_counter--) {
		ret = __fincore(fd, NULL, offset, length);
		if (ret < 0) {
			fprintf(stderr, "%s: fincore() failed: %s\n",
				progname, strerror(errno));
			exit(1);
		}
		if (loops == 1)
			printf("%ld\n", ret);
	}
	close(fd);
	exit(0);
}
