/*
 * Try to reproduce Jasper Spaans' report.
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>

#define NFILES	100
#define SIZE (10*1000*1000)

int main(int argc, char *argv[])
{
	int fd;
	int i;
	char filename[NFILES];
	void *mem;

	if (argc != 1) {
		fprintf(stderr,
			"Usage; %s\n", argv[0]);
		exit(1);
	}

	for (i = 0; i < 100; i++) {
		sprintf(filename, "foo-%03d", i);
		fd = open(filename, O_RDWR|O_CREAT|O_TRUNC);
		if (fd < 0) {
			fprintf(stderr, "%s: Cannot open `%s': %s\n",
				argv[0], filename, strerror(errno));
			exit(1);
		}
		if (ftruncate(fd, SIZE) < 0) {
			fprintf(stderr, "%s: error truncating `%s': %s\n",
				argv[0], filename, strerror(errno));
			exit(1);
		}
		mem = mmap(0, SIZE, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);
		if (mem == MAP_FAILED) {
			perror("mmap");
			exit(1);
		}
		close(fd);
		memset(mem, 0, SIZE);
		munmap(mem, SIZE);
	}
	for (i = 0; i < 100; i++) {
		sprintf(filename, "foo-%03d", i);
		unlink(filename);
	}
	exit(0);
}
