/*
 * mmap a file, munmap bits, play with them.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <time.h>
#include <setjmp.h>
#include <sys/wait.h>
#include <sys/mman.h>

#include <asm/unistd.h>

#ifndef MREMAP_MAYMOVE
#define MREMAP_MAYMOVE  1
#endif

#ifndef MREMAP_FIXED
#define MREMAP_FIXED    2
#endif

#define ALIGN(x,a) (((x)+(a)-1)&~((a)-1))

char *ourname;
char *filename;
int got_segv;

void usage(void)
{
	fprintf(stderr,
	"Usage: %s filename\n"
		"",
			ourname);
	exit(1);
}

jmp_buf env;

void sigsegv(int sig)
{
	got_segv = 1;
	longjmp(env, 1);
}

volatile signed char c;

int segv(char *p)
{
	signal(SIGSEGV, sigsegv);
	got_segv = 0;
	if (!setjmp(env)) {
		volatile char *pp = p;

		c = *pp;
	}
	return got_segv;
}

unsigned long getnum(char *p)
{
	unsigned long ret;

	if (!strncmp(p, "0x", 2))
		ret = strtoul(p + 2, NULL, 16);
	else
		ret = strtoul(p, NULL, 10);
	return ret;
}

void err(void)
{
	fprintf(stderr, "parse error\n");
	exit(1);
}

void get1(char *buf, unsigned long *a1)
{
	char c;

	if (sscanf(buf, "%c 0x%lx", &c, a1) != 2)
		err();
}

void get2(char *buf, unsigned long *a1, unsigned long *a2)
{
	char c;

	if (sscanf(buf, "%c 0x%lx 0x%lx", &c, a1, a2) != 3)
		err();
}

void get3(char *buf, unsigned long *a1, unsigned long *a2, unsigned long *a3)
{
	char c;

	if (sscanf(buf, "%c 0x%lx 0x%lx 0x%lx", &c, a1, a2, a3) != 4)
		err();
}

void get4(char *buf, unsigned long *a1,
		unsigned long *a2, unsigned long *a3, unsigned long *a4)
{
	char c;

	if (sscanf(buf, "%c 0x%lx 0x%lx 0x%lx 0x%lx", &c, a1, a2, a3, a4) != 5)
		err();
}

void doit(int fd)
{
	char buf[200];
	unsigned long offset;
	unsigned long length;
	unsigned long addr;
	unsigned long old_addr, old_size, new_addr, new_size;
	char *map;

	while (fgets(buf, sizeof(buf), stdin)) {
		switch (buf[0]) {
		case 'm':	/* m offset len */
			get2(buf, &offset, &length);
			map = mmap(NULL, length, PROT_READ|PROT_WRITE,
					MAP_SHARED, fd, offset);
			if (map == MAP_FAILED) {
				perror("mmap");
				continue;
			}
			printf("map: 0x%lx (size 0x%lx) to 0x%lx\n",
				(long)map, length, (long)map + length);
			break;
		case 'u':	/* u addr len */
			get2(buf, &addr, &length);
			if (munmap((void *)addr, length)) {
				perror("munmap");
				continue;
			}
			break;
		case 's':	/* s addr */
			get1(buf, &addr);
			if (!segv((char *)addr)) {
				fprintf(stderr, "no segv at 0x%lx\n",
					addr);
				continue;
			}
			printf("OK, segv at 0x%lx\n", addr);
			break;
		case 'S':	/* S addr */
			get1(buf, &addr);
			if (segv((char *)addr)) {
				fprintf(stderr, "segv at 0x%lx\n",
					addr);
				continue;
			}
			printf("OK, no segv at 0x%lx\n", addr);
			break;
		case 'r':	/* r old_addr old_size new_size */
			get3(buf, &old_addr, &old_size, &new_size);
			map = mremap((void *)old_addr, old_size,
					new_size, MREMAP_MAYMOVE);
			if (map == MAP_FAILED) {
				perror("mremap");
				continue;
			}
			printf("remapped to 0x%lx (size 0x%lx) to 0x%lx\n",
				(long)map, new_size, (long)map + new_size);
			break;
		case 'f':	/* f old_addr old_size new_addr new_size */
			get4(buf, &old_addr, &old_size, &new_addr, &new_size);
			map = mremap((void *)old_addr,
					old_size,
					new_size,
					MREMAP_FIXED|MREMAP_MAYMOVE);
			if (map == MAP_FAILED) {
				perror("mremap");
				continue;
			}
			printf("remapped to 0x%lx (size 0x%lx) to 0x%lx\n",
				(long)map, new_size, (long)map + new_size);
			break;
		case 'q':
			return;
		default:
			fprintf(stderr, "eh?\n");
			exit(1);
		}
	}
}

int main(int argc, char *argv[])
{
	int fd;

	ourname = argv[0];
	while ((c = getopt(argc, argv, "")) != -1) {
		switch (c) {
		default:
			usage();
		}
	}

	if (optind == argc)
		usage();
	filename = argv[optind++];

	if (optind != argc)
		usage();

	fd = open(filename, O_CREAT|O_RDWR, 0666);
	if (fd < 0) {
		fprintf(stderr, "%s: failed to open `%s': %s\n",
			ourname, filename, strerror(errno));
		exit(1);
	}

	printf("/proc/%d/maps\n", getpid());
	doit(fd);
	exit(0);
}
