/*
 * pwrite some data at a file offset
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

int main(int argc, char *argv[])
{
	int fd;
	loff_t size;
	loff_t offset;
	char *filename;
	char *buf;

	if (argc != 4) {
		fprintf(stderr, "Usage; %s filename size offset\n", argv[0]);
		exit(1);
	}

	filename = argv[1];
	fd = open(filename, O_LARGEFILE|O_CREAT|O_RDWR, 0666);
	if (fd < 0) {
		fprintf(stderr, "%s: Cannot open `%s': %s\n",
			argv[0], filename, strerror(errno));
		exit(1);
	}

	sscanf(argv[2], "%Ld", &size);
	sscanf(argv[3], "%Ld", &offset);
	buf = malloc(size);
	if (buf == 0) {
		fprintf(stderr, "enomem\n");
		exit(1);
	}
	memset(buf, 0, size);
	printf("pwrite(%Ld, %Ld)\n", size, offset);
	if (pwrite(fd, buf, size, offset) != size) {
		perror("pwrite");
		exit(1);
	}
	exit(0);
}
