/*
 * Lorenzo Allegrucci <lenstra@tiscalinet.it>
 * The original qsbench
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <time.h>

int cmp(const void * x, const void * y)
{
	int *a, *b;

	a = (int *)x;
	b = (int *)y;

	if (*a == *b)
		return 0;
	else
		if (*a > *b)
			return 1;
		else
			return -1;
}

int main(int argc, char *argv[])
{
	int *a, n, i, errors = 0;

	n = atoi(argv[1]);

	if ((a = malloc(sizeof(int) * n)) == NULL) {
		perror("malloc");
		exit(1);
	}
	srand(1);
	for (i = 0; i < n; i++)
		a[i] = rand();

	qsort(a, n, sizeof(int), cmp);

	for (i = 0; i < n - 1; i++)
		if (a[i] > a[i + 1])
			errors++;
	printf("%d errors.\n", errors);
	free(a);
	return 0;
}

