/*
 * Copyright (C) Ingo Molnar, 2002
 */
#include <stdio.h>
#include <unistd.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/times.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <linux/unistd.h>

#define PAGE_SIZE 4096
#define PAGE_WORDS (PAGE_SIZE/sizeof(int))

#define CACHE_PAGES 1024
#define CACHE_SIZE (CACHE_PAGES*PAGE_SIZE)

#define WINDOW_PAGES 16
#define WINDOW_SIZE (WINDOW_PAGES*PAGE_SIZE)

#define WINDOW_START 0x48000000

#define PROT (PROT_READ|PROT_WRITE)
#if 0
#define PROT2 (PROT_READ|PROT_WRITE)
#define PROT3 (PROT_READ|PROT_WRITE)
#else
#define PROT2 (PROT_READ)
#define PROT3 (PROT_READ)
#endif

static char cache_contents [CACHE_SIZE];

int main(int argc, char **argv)
{
	unsigned int *data = NULL;
	int i, j, fd, offset = 30;
	unsigned char *ptr;
	char filename[100];
	int err;

	remap_file_pages((void *)-1, -1, -1, -1, -1);
	sprintf(filename, "/tmp/cache%d", getpid());
	fd = open(filename, O_RDWR|O_CREAT|O_TRUNC,S_IRWXU);

	if (fd < 0) {
		perror("death");
		printf("could not open cachefile!\n");
		exit(1);
	}

	for (i = 0; i < CACHE_PAGES; i++) {
		int *page = (int *) (cache_contents + i*PAGE_SIZE);

		for (j = 0; j < PAGE_WORDS; j++)
			page[j] = i;
	}

	if (write(fd, cache_contents, CACHE_SIZE) != CACHE_SIZE) {
		perror("death");
		printf("could not write cachefile!\n");
		exit(1);
	}
	close(fd);
//	chmod(filename, S_IRUSR);
	fd = open(filename, O_RDWR,S_IRWXU);

	ptr = mmap(0,
			WINDOW_SIZE,
			PROT, 
			MAP_SHARED 
//			| MAP_POPULATE
			, fd, 0);

	if (ptr == MAP_FAILED) {
		printf("mmap() failed, ptr = %p!\n", ptr);
		exit(1);
	}

	remap_file_pages((void *)ptr, 0x1000, PROT2, 0, 0);
	data = (unsigned int *) ptr;
	printf("data mapping: %p\n", data);

	printf("mapping pages in reverse order via remap_file_pages():\n");

again:
	for (i = 0; i < WINDOW_PAGES; i += 2) {
		unsigned int *page = data + i*(PAGE_SIZE/sizeof(int));

		err = remap_file_pages(
				(void *)page,
				PAGE_SIZE * 2,
				0, /// PROT3,
				(WINDOW_PAGES-i+offset),
				0);
		if (err) {
			printf("mmap() of page %d failed, errno = %d\n", i, errno);
			exit(1);
		}
		printf("remapped page %d to %p.\n", i, page);
	}

//		sleep(5);

	printf("page contents:\n");
	for (i = 0; i < WINDOW_PAGES; i++) {
		int index = i*(PAGE_SIZE/sizeof(int));
		printf(".. data[%d] (page %d/%p): %d - ",
		       index, i, data + index, data[index]);
		fflush(stdout);

		/*
		 * Double-check the correctness of the mapping:
		 */
		if (i & 1) {
			if (data[index] != WINDOW_PAGES-i+offset+2) {
				printf("hm, mapped incorrect data!\n");
				exit(1);
			}
			data[index] = WINDOW_PAGES-i+offset+2;
		} else {
			if (data[index] != WINDOW_PAGES-i+offset) {
				printf("hm, mapped incorrect data!\n");
				exit(1);
			}
			data[index] = WINDOW_PAGES-i+offset;
		}
		printf("OK.\n");
	}
	if (--offset >= 0) {
		goto again;
	}

//	for (;;) sleep(1);

	return 0;
}

#if defined(__ia64__)

asm(
"	.text\n"
"	.global __ia64_syscall#;\n"
"	.align	32;\n"
"	.proc	__ia64_syscall#;\n"
"__ia64_syscall#:\n"
"	.regstk 6,0,0,0\n"
"	mov r15=in5\n"
"	break 0x100000\n"
"	movl r2=errno\n"
"	cmp.eq p6,p7=-1,r10\n"
"	;;\n"
"(p6)	st4 [r2]=r8\n"
"(p6)	mov r8=-1\n"
"	br.ret.sptk.many rp\n"
"	.endp	__ia64_syscall#\n"
);

#endif
