#!/bin/sh
#
# make-patches.sh
#
# Make the individual patches for ext3
#
# Usage: make-patches.sh name_of_vanilla_kernel_tree name_of_patched_kernel_tree
#
# Uses scripts/file-manifest
#
# Must be run from the root of the ext3 CVS tree.  Places patches in
# ./patches
#
# Assumes that both kernel trees and the ext3 CVS tree all live
# in the same directory (eg: /usr/src)

usage()
{
	echo Usage: make-patches.sh name_of_vanilla_kernel_tree name_of_patched_kernel_tree
	exit 1
}

wantdir()
{
	if [ ! -d $1 ]
	then
		echo $1: no directory by that name in $(/bin/pwd)
		exit 1
	fi
}

#
# Look at a file, decide what to do with it
# Runs from ext3 CVS root dir
#
consider_file()
{
	file=$1
	echo Considering $file

	if [ -f $file ]
	then
		echo $file exists in CVS tree.  No patch needed.
	else
		BASENAME=$(basename $file)
		DIRNAME=$(dirname $file)
		mkdir -p $EXT3_CVS_DIR/patches/$DIRNAME
		cd ..
		diff -u $VANILLA_KERNEL_TREE/$file $PATCHED_KERNEL_TREE/$file \
			| $EXT3_CVS_DIR/scripts/strip-diff-dates.sh \
			 > $EXT3_CVS_DIR/patches/$DIRNAME/"$BASENAME".patch
	fi
}

#
# Look at a bunch of files, decide what to do with them
#
consider_files()
{
	for i in $*
	do
		cd $EXT3_CVS_DIR
		consider_file $i
	done
}

if [ $# != 2 ]
then
	usage
fi

EXT3_CVS_DIR=$(/bin/pwd)
VANILLA_KERNEL_TREE=$1
PATCHED_KERNEL_TREE=$2
cd ..
wantdir $VANILLA_KERNEL_TREE
wantdir $PATCHED_KERNEL_TREE
cd $EXT3_CVS_DIR

FILES_TO_CONSIDER=$(cat scripts/file-manifest)

consider_files $FILES_TO_CONSIDER

cd $EXT3_CVS_DIR
scripts/print-kernel-version.sh ../$PATCHED_KERNEL_TREE > kernel-version.txt
echo
echo "Successfully built patches from $VANILLA_KERNEL_TREE and $PATCHED_KERNEL_TREE"
