#!/bin/sh
#
# Strip the date fields out of unified diffs so they don't get committed into
# CVS if nothing has changed.
#
# Usage: strip-diff-dates.sh filename
#        strip-diff-dates.sh 
#

if [ $# -gt 1 ]
then
	echo Usage: strip-diff-dates.sh filename
	echo        strip-diff-dates.sh filename
	exit 1
fi

cat $1 | sed -e 's/^--- \([^ 	]*\).*/--- \1/' -e 's/^+++ \([^ 	]*\).*/+++ \1/' 
