#ifndef _SPELLS_H
#define _SPELLS_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#include <deque>
#include <map>
#include <vector>

using namespace std;

enum Gesture {
    GST_NOTHING,
    GST_KNIFE,
    GST_FINGER,
    GST_PALM,
    GST_SNAP,
    GST_WAVE,
    GST_POINT,
    GST_CLAP,
    GST_ANTISPELL,
    GST_FOG
};

enum Spell {
    SPL_NONE,
    SPL_SHIELD,
    SPL_COUNTER_SPELL,
    SPL_COUNTER_SPELL1,
    SPL_MAGIC_MIRROR,
    SPL_DISPEL_MAGIC,
    SPL_RAISE_DEAD,
    SPL_CURE_LIGHT_WOUNDS,
    SPL_CURE_HEAVY_WOUNDS,
    SPL_MISSILE,
    SPL_FINGER_OF_DEATH,
    SPL_LIGHTNING_BOLT,
    SPL_LIGHTNING_BOLT1,
    SPL_CAUSE_LIGHT_WOUNDS,
    SPL_CAUSE_HEAVY_WOUNDS,
    SPL_FIREBALL,
    SPL_FIRESTORM,
    SPL_ICESTORM,
    SPL_AMNESIA,
    SPL_CONFUSION,
    SPL_CHARM_PERSON,
    SPL_CHARM_MONSTER,
    SPL_PARALYSIS,
    SPL_FEAR,
    SPL_ANTI_SPELL,
    SPL_PROTECTION_FROM_EVIL,
    SPL_RESIST_HEAT,
    SPL_RESIST_COLD,
    SPL_DISEASE,
    SPL_POISON,
    SPL_BLINDNESS,
    SPL_INVISIBILITY,
    SPL_HASTE,
    SPL_TIME_STOP,
    SPL_DELAYED_EFFECT,
    SPL_PERMANENCY,
    SPL_REMOVE_ENCHANTMENT,
    SPL_SUMMON_GOBLIN,
    SPL_SUMMON_OGRE,
    SPL_SUMMON_TROLL,
    SPL_SUMMON_GIANT,
    SPL_SUMMON_FIRE_ELEMENTAL,
    SPL_SUMMON_ICE_ELEMENTAL,
    SPL_SURRENDER,
    SPL_STAB,
    SPL_FINAL_MARKER
};

class Spells {
public:
    struct GesturePair {
	GesturePair(Gesture Primary, Gesture Secondary);
	GesturePair();

	Gesture primaryGesture;
	Gesture secondaryGesture;
	// If the secondary is GST_NOTHING then it can be anything
    };

    static const deque<GesturePair> &getGesturesForSpell(const enum Spell 
							 Spell);

    static int getSpellsForGestures(const deque<Gesture> &PrimaryHand, 
				    const deque<Gesture> &SecondaryHand,
				    vector<Spell> *SpellList);

    static const char *getSpellName(Spell SpellID);
    static const char *getGestureName(Gesture GestureID);
    
    static const vector<Spell> &getSpellsNullifiedByDispellMagic(); 

    // Spells which if cast simultaneously on a target cancel each other out
    static const vector<Spell> &getEnchantmentSpellsCancelled();

    static bool spellIsReflectable(Spell TestSpell);
//     static const vector<Spell> &getReflectableSpells();

    static bool CastOrderCompare(Spell First, Spell Second);

private:
    static void init();
    static bool classInitialised;

    static map< Spell, deque<GesturePair> > spellToGestureMap;
    static vector<Spell> spellsNullifiedByDispelMagic;
    static vector<Spell> spellsEnchantmentCancelled;
};


#endif
