#ifndef _LOGFILE_H
#define _LOGFILE_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#include <string>
#include <stdio.h>
#include <stdarg.h>

using namespace std;

class LogFile {
public:

    enum LogLevel {
	NORMAL,
	DEBUG1,
	DEBUG2,
	DEBUG3
    };
    
    // Open log file
    static bool OpenLog(const string &Filename);

    static void SetLogLevel(LogLevel Level);
    // Anything below this level will not be logged

    static void Log(const char *Message, ...);
    static void Log(LogLevel Level, const char *Message, ...);

    static bool CloseLog();

private:
    static void LogToFile(LogLevel Level, const char *Message, va_list *Args);
    static LogLevel logLevel;
    static FILE *logFile;
    static char *logLevelStrings[4];
    static bool initLogLevelStrings;
};


#endif
