/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#include <stdio.h>
#include "GameConfig.H"


map<string, string> GameConfig::configValues;

void
GameConfig::Initialise()
{
    // Default values for game
    configValues["StartTimeout"] = "30";
    configValues["TurnTimeout"] = "120";

    
}

bool
GameConfig::GetConfig(const string &Config, string *Value) 
{
    if (configValues.find(Config)==configValues.end()) {
	return false;
    }

    *Value = configValues[Config];

    return true;
}

bool
GameConfig::GetConfig(const string &Config, int *Value) 
{
    if (configValues.find(Config)==configValues.end()) {
	return false;
    }

    string value = configValues[Config];
    *Value = atoi(value.c_str());

    return true;
}

bool
GameConfig::ReadConfigFile(const string &ConfigFile)
{
    FILE *configFile;
    configFile = fopen(ConfigFile.c_str(), "r");
    if (!configFile) return false;

    char *value;
    char input_line[100];
    memset(input_line, 0, 100);

    while (fgets(input_line, 99, configFile)) {
	value = strstr(input_line, "\t");
	if (value && input_line[0]!='#') {
	    value[0] = 0;
	    value++;
	    // Remove newline
	    if (strlen(value)>0) value[strlen(value)-1] = 0;
	    configValues[input_line] = value;
	    printf("Adding configuration %s: %s\n", input_line, value);
	}
    }

    fclose(configFile);
    return true;
}
