/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#include <stdio.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include <assert.h>
#include <errno.h>
#include <unistd.h>
#include <netinet/in.h>

#include "../client/SCClient.H"
#include "../client/protocol.h"

#define SERVER_PORT 12701

void SendGestures(SCClient *Client)
{
    Client->sendGestures(GST_KNIFE, GST_NOTHING);
}

void Play(SCClient *Client)
{
    // Wait for game start
    int msg;
    Spell leftSpell = SPL_NONE, rightSpell = SPL_NONE;

    while (1) {
	Client->readData();
	while (Client->messageAvailable()) {
	    msg = Client->processMessage();
	    switch (msg) {
	    case MSG_SEND_NEWPLAYER_INFO:
		printf("Received new player info\n");
		break;

	    case MSG_ASK_FOR_GESTURES:
		printf("Asked for gestures\n");
		SendGestures(Client);
		sleep(5);
		break;

	    case MSG_SEND_GESTURES_SEEN:
		printf("Have been sent gestures\n");
		break;

	    case MSG_ASK_FOR_SPELLS_CAST:
		printf("Asked for spell selection\n");
		{
		    vector<Spell> leftSpells, rightSpells;
		    Client->getPossibleSpells(&leftSpells, &rightSpells);
		    if (leftSpells.size()>0) {
			leftSpell = leftSpells[0];
			printf("Have left spell %s\n", 
			       Spells::getSpellName(leftSpell));
		    } else {
			leftSpell = SPL_NONE;
		    }
		    if (rightSpells.size()>0) {
			rightSpell = rightSpells[0];
			printf("Have right spell %s\n", 
			       Spells::getSpellName(rightSpell));
		    } else {
			rightSpell = SPL_NONE;
		    }
		    Client->sendSpellSelection(leftSpell, rightSpell);
		}

	    case MSG_ASK_SPELL_DIRECTIONS:
		printf("Been asked for who to send spells on\n");
		{
		    int leftTarget = 0, rightTarget = 0;
		    if (leftSpell!=SPL_NONE) leftTarget = Client->getOwnID();
		    if (rightSpell!=SPL_NONE) rightTarget = Client->getOwnID();
		    printf("Targets are: %i %i\n", leftTarget, rightTarget);
		    Client->sendSpellTargets(leftTarget, rightTarget);

		}
		    break;

	    case MSG_SEND_SPELL_CAST:
		printf("Received info about spell that has been cast\n");
		break;

	    case MSG_SEND_END_GAME:
		printf("Game has ended\n");
		break;

	    case MSG_SEND_START_GAME:
		printf("Game has started.\n");
		printf("Own ID is %i. Turn timeout is %i\n",
		       Client->getOwnID(), Client->getTurnTimeout());
		break;

	    default:
		;
	    }
	}
    }
}

int main(int argc, char *argv[])
{
    struct sockaddr_in sa;
    struct hostent *server;

    server = gethostbyname("localhost");
    assert(server);

    int fd = socket(AF_INET, SOCK_STREAM, 0);
    if (fd<0) {
	perror("Could not create socket");
	exit(1);
    }

    memset(&sa, 0, sizeof(struct sockaddr_in)); 
    sa.sin_family = AF_INET;
    sa.sin_port = htons(SERVER_PORT);
    memcpy(&sa.sin_addr.s_addr, server->h_addr_list[0], server->h_length);
    
    if (connect(fd, (struct sockaddr *)&sa, sizeof(sa))<0) {
	perror("Connect failed\n");
	exit(1);
    }

    printf("Creating Client object %s\n", argv[1]);
    SCClient client(fd, argv[1]);

    printf("Server message: %s\n", client.getServerWelcomeMessage().c_str());

    Play(&client);

    exit(1);

}
