#include "Elemental.H"
#include "protocol.h"
#include <assert.h>

Elemental::Elemental(Wizard *Owner, int MonsterType)
    : NonWizard(MonsterType, 3, 3, Owner)
{
    assert(MonsterType==SC_MONSTER_FIRE_ELEMENTAL ||
	   MonsterType==SC_MONSTER_ICE_ELEMENTAL);
}

bool
Elemental::applyConfusionSpell(string *Message)
{
    *Message = "%S casts Confusion on %T but it has no effect";
    return false;
}

bool
Elemental::applyCharmMonsterSpell(string *Message)
{
    *Message = "%S casts Charm Monster on %T but it has no effect";
    return false;
}

bool
Elemental::applyParalysisSpell(string *Message)
{
    *Message = "%S casts Paralysis on %T";
    setStateBits(CS_PARALYSIS);
    return true;
}

bool
Elemental::applyResistHeatSpell(string *Message)
{
    if (getMonsterType()==SC_MONSTER_FIRE_ELEMENTAL) {
	*Message = "%S casts Resist Heat on %T and destroys it\n";
	setStateBits(CS_DEAD);
	return true;
    } else {
	*Message = "%S casts Resist Heat on %T but it has no effect\n";
	return false;
    }
}

bool
Elemental::applyResistColdSpell(string *Message)
{
    if (getMonsterType()==SC_MONSTER_ICE_ELEMENTAL) {
	*Message = "%S casts Resist Cold on %T and destroys it\n";
	setStateBits(CS_DEAD);
	return true;
    } else {
	*Message = "%S casts Resist Cold on %T but it has no effect\n";
	return false;
    }
}

bool
Elemental::applyFireStormSpell(string *Message)
{
    if (getMonsterType()==SC_MONSTER_FIRE_ELEMENTAL) {
	*Message = "%S is engulfed by the firestorm and disappears";
	setStateBits(CS_DEAD);
	return true;
    } else {
	return NonWizard::applyFireStormSpell(Message);
    }
}

bool
Elemental::applyIceStormSpell(string *Message)
{
    if (getMonsterType()==SC_MONSTER_ICE_ELEMENTAL) {
	*Message = "%S is engulfed by the icestorm and disappears";
	setStateBits(CS_DEAD);
	return true;
    } else {
	return NonWizard::applyIceStormSpell(Message);
    }
}

