#ifndef _PLAYER_H
#define _PLAYER_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#include "Wizard.H"
#include "RemoteConnection.H"
#include "protocol.h"
#include "NonWizard.H"

class Player : public Wizard {
public:

    struct SpellCast {
	Player *source;
	BaseCreature *target;
	Spell spellCast;
	bool spellWorked;
	string resultMessage;

    };

    class SpellCastPredicateSpellEqual {
    public:
	SpellCastPredicateSpellEqual(Spell SpellToMatch)
	    : matches(dummy)
	{
	    matches.clear();
	    spellsToMatch.push_back(SpellToMatch);
	}

	SpellCastPredicateSpellEqual(Spell SpellToMatch, 
				     vector<SpellCast> &RecordMatches)
	    : matches(RecordMatches)
	{
	    spellsToMatch.push_back(SpellToMatch);
	}


	SpellCastPredicateSpellEqual(const vector<Spell> &SpellsToMatch)
	    : spellsToMatch(SpellsToMatch), matches(dummy) {
	    matches.clear();
	}
    
	SpellCastPredicateSpellEqual(const vector<Spell> &SpellsToMatch,
				     vector<SpellCast> &RecordMatches)
	    : spellsToMatch(SpellsToMatch), matches(RecordMatches) {}
    
	bool operator()(SpellCast SpellCastInstance) {
	    if (find(spellsToMatch.begin(),
		     spellsToMatch.end(), SpellCastInstance.spellCast)
		!= spellsToMatch.end()) {
		matches.push_back(SpellCastInstance);
		return true;
	    } else {
		return false;
	    }
	}

	void clearMatches() {
	    matches.clear();
	}

	const vector<SpellCast> &getMatches() const {
	    return matches;
	}

    private:
	vector<Spell> spellsToMatch;
	vector<SpellCast> &matches;
	static vector<SpellCast> dummy; 
	// bje says that static is an alternative source of energy
    };
    
    class SpellCastOrderCompare {
    public:
	bool operator()(const SpellCast &First, const SpellCast &Second) const{
	    return First.spellCast < Second.spellCast;
	}
    };

    
    Player(int FD, int ProtocolVersion, vector<string> &PlayerNameList);

    void sendStartGame(int Timeout, int MaxRounds);

    void sendNewPlayerInfo(Player *NewPlayer);
    void sendNewMonsterInfo(NonWizard *Monster);
    void askForGestures();

    void sendGesturesSeen(Player *OfPlayer);
    void sendGesturesSeenEnd();
    
    void askForSpellSelection(const vector<Spell> &LeftHandSpells,
			      const vector<Spell> &RightHandSpells);

    void getSpellsSevoidlected(Spell *LeftHandSpell, Spell *RightHandSpell);
    // might not need this one?

    // Ask player who to direct spells at
    void askForSpellDirections(const vector<int> &ValidTargetIDs);

    // Ask player who to direct monsters at
    void askForMonsterDirections(const vector<int> &ValidTargetIDs);

    void getSpellsCast(Spell *LeftHandSpell, int *LeftTargetID,
		       Spell *RightHandSpell, int *RightTargetID);


    // Ask player which hand to charm
    void askForHandToCharm(Player *Target);

    // Ask player which hand to charm
    void askForHandToParalyze(Player *Target);

    // Ask player which gesture charmed target should make
    void askCharmedGesture(Player *Target);

    // Get where monsters were directed by player
    const map<NonWizard *, int> &getMonsterDirections() const;

    // Tell players what spells have been cast
    void sendSpellCast(const SpellCast &SpellInfo);
    void sendSpellCastEnd(); // Sent all information about spells cast

    // Tell players result of monster attacks
    void sendMonsterAttack(int SourceID, int TargetID, int Damage,
			    const string &ResultMessage);
    void sendMonsterAttackEnd();

    // Tell players of the state of all other creatures
    void sendCreatureState(BaseCreature *Creature);
    void sendCreatureStateEnd();

    // Tell players that game has ended
    void sendEndGame(Player *Winner);
    void sendEndGame(const vector<Player *> &Winners);

    // Send a message
    void sendEventMessage(int EventType, int MessageSource, 
			  int Source, int Target, int Misc,
			  const string &Message);

    // Repeat last gestures
    void repeatLastGestures();
    // In case of amnesia we need to use the last real gestures

    // Change gesture for paralysis
    void changeGestureForParalysis();
    // Makes paralysed hand do the same gesture as last round

    // Charm person spell
    bool applyCharmPersonSpell(string *Message, BaseCreature *Source);

    // So we can work out when game can proceed
    bool amWaitingForResponse() const;
    void clearWaitForResponse();
    void setWaitForResponse();

    const RemoteConnection &connection() const;
    RemoteConnection &connection();

    // Process incoming message
    void ProcessMessage();

    virtual void Reset();

    void setHandParalysed(int Hand);
    int getHandParalysed() const;
    
    void setHandCharmed(int Hand);
    int getHandCharmed() const;

    void setCharmGesture(Gesture NewGesture);

    bool haveUsedShortLightning() const;

    void DisconnectClient();

private:

    RemoteConnection remoteConnection;
    bool waitingForResponse;
    Spell leftHandSpell, rightHandSpell;
    int leftHandSpellTargetID, rightHandSpellTargetID;
    bool leftHandSpellTarget, rightHandSpellTarget;
    vector<Spell> validLHSpells;
    vector<Spell> validRHSpells;
    vector<int> validTargetIDs;
    map<NonWizard *, int> monsterTargets;
    int handParalysed; // 1 is left, 2 is right
    int handCharmed;  // 1 is left, 2 is right
    bool usedShortLightning;
    vector<string> &playerNameList;
};


#endif

