#ifndef _WIZARD_H
#define _WIZARD_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#include "BaseCreature.H"
#include "GestureHistory.H"

class NonWizard;

class Wizard : public BaseCreature {
public:
    Wizard();
    
    void addGestures(Gesture LeftHand, Gesture RightHand);

    void setLeftGesture(Gesture NewGesture);
    void setRightGesture(Gesture NewGesture);

    const GestureHistory &getGestureHistory() const;

    /* Protection Spells */
    bool applyRemoveEnchantmentSpell(string *Message);
    bool applyDispelMagicSpell(string *Message);

    /* Enchantments */
    bool applyCharmPersonSpell(string *Message, BaseCreature *Source);
    bool applyCharmMonsterSpell(string *Message, BaseCreature *Source);
    bool applyFearSpell(string *Message);
    bool applyAntiSpell(string *Message);
    bool applyBlindnessSpell(string *Message);
    bool applyInvisibilitySpell(string *Message);
    bool applyDelayedEffectSpell(string *Message);
    bool applyPermanencySpell(string *Message);
    
    // Monsters wizard owns
    void addMonster(NonWizard *Monster);
    const vector<NonWizard *> &getMonsters() const;
    void removeMonster(NonWizard *Monster);

    Wizard *getCharmer() const;

    virtual void decrementCounters();
    virtual void Reset();
    
private:
    int counterBlindness;
    int counterInvisibility;
    int counterFear;
    int counterCharmPerson;
    GestureHistory gestures;
    vector<NonWizard *> monstersControlled;
    Wizard *charmer;
};

#endif
