#ifndef _PROTOCOL_H
#define _PROTOCOL_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#define DEFAULT_SPELLCAST_SERVER_PORT 12701
#define SPELLCAST_PROTOCOL_VERSION 4

#define MSG_ASK_WELCOME 1
#define MSG_RCV_CLIENT_DETAILS 2
#define MSG_ASK_FOR_GESTURES 3
#define MSG_RCV_GESTURES_USED 4
#define MSG_ASK_FOR_SPELLS_CAST 5
#define MSG_RCV_SPELLS_CAST 6
#define MSG_SEND_GESTURES_SEEN 7
#define MSG_ASK_SPELL_DIRECTIONS 8
#define MSG_RCV_SPELL_DIRECTIONS 9
#define MSG_SEND_SPELL_CAST 10
#define MSG_SEND_CREATURE_STATE 11
#define MSG_SEND_END_GAME 12
#define MSG_SEND_NEWPLAYER_INFO 13
#define MSG_ASK_MONSTER_DIRECTIONS 15
#define MSG_RCV_MONSTER_DIRECTIONS 16
#define MSG_SEND_NEW_MONSTER_INFO 17
#define MSG_SEND_MONSTER_ATTACK_INFO 18
#define MSG_SEND_EVENT_INFO 19
#define MSG_SEND_START_GAME 20
#define MSG_ASK_CHARM_PERSON_CTRL_HAND 21
#define MSG_ASK_PARALYSIS_CTRL_HAND 22
#define MSG_ASK_CHARM_PERSON_CTRL_GESTURE 23
#define MSG_RCV_CHARM_PERSON_CTRL_HAND 24
#define MSG_RCV_PARALYSIS_CTRL_HAND 25
#define MSG_RCV_CHARM_PERSON_CTRL_GESTURE 26
#define MSG_USERNAME_IN_USE_ALREADY 27

#define SC_MONSTER_GOBLIN 1
#define SC_MONSTER_OGRE 2
#define SC_MONSTER_TROLL 3
#define SC_MONSTER_GIANT 4
#define SC_MONSTER_FIRE_ELEMENTAL 5
#define SC_MONSTER_ICE_ELEMENTAL 6

#define SC_EVT_GENERIC_MESSAGE 1
#define SC_EVT_ELEMENTAL_MERGE 2
#define SC_EVT_ELEMENTAL_CANCEL 3
#define SC_EVT_PLAYER_AMNESIA 4
#define SC_EVT_CONFUSION 5
#define SC_EVT_PLAYER_FEAR 6
#define SC_EVT_MONSTER_PARALYSIS 7
#define SC_EVT_NO_OWNER_MONSTER_DIES 8
#define SC_EVT_PLAYER_DIED 9
#define SC_EVT_COUNTER_SPELL_NEGATE 10
#define SC_EVT_DISPEL_MAGIC_NEGATE 11
#define SC_EVT_DISPEL_MAGIC_DESTROY_MONSTER 12
#define SC_EVT_MAGIC_MIRROR_FAIL 13
#define SC_EVT_FOD_CANCELS_RAISE_DEAD 14

#define SC_LEFT_HAND 1
#define SC_RIGHT_HAND 2

#endif /* _PROTOCOL_H */
