#ifndef _BASECREATURE_H
#define _BASECREATURE_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#include <map>
#include <string>

#include "Spells.H"
#include "protocol.h"

using namespace std;

#define ENCHANTMENT_SPELLS ( \
    CS_AMNESIA | CS_PERM_AMNESIA | CS_CONFUSION | CS_PERM_CONFUSION |\
    CS_CHARM_PERSON | CS_PERM_CHARM_PERSON | CS_PARALYSIS | \
    CS_PERM_PARALYSIS | CS_FEAR | CS_PERM_FEAR | CS_ANTI_SPELL | \
    CS_PROT_FROM_EVIL | CS_PERM_PROT_FROM_EVIL | CS_RESIST_HEAT | \
    CS_RESIST_COLD | CS_DISEASED | CS_POISONED | CS_BLINDED | \
    CS_PERM_BLINDED | CS_INVISIBILITY | CS_PERM_INVISIBILITY | \
    CS_HASTE | CS_PERM_HASTE | CS_TIMESTOP | CS_DELAYED_EFFECT )

class NonWizard;

class BaseCreature {
public:
    BaseCreature(int DamageInflicted, int NumHitPoints);
    virtual ~BaseCreature();

    int getID() const;
    static BaseCreature *mapIDToPointer(int ID);
    static bool validID(int ID);

    int getNumHitPoints() const;
    int getMaxNumHitPoints() const;
    void setNumHitPoints(int NumHitPoints);
    void changeNumHitPoints(int Delta);
    
    void setName(const char *Name);
    const char *getName() const;

    unsigned int getState() const;
    bool isStateSet(int StateBits) const;
    virtual void setState(unsigned int State);
    virtual void setStateBits(unsigned int StateBits);
    virtual void clearStateBits(unsigned int StateBits);

    int getcounterProtFromEvil() const;
    int getcounterDisease() const;
    int getcounterPoison() const;

    int getDamageInflicted() const;

    bool applySpell(Spell SpellToApply, string *Message, BaseCreature *Source);

    /* Protection spells */
    virtual bool applyShieldSpell(string *Message);
    virtual bool applyRemoveEnchantmentSpell(string *Message) = 0;
    virtual bool applyMagicMirrorSpell(string *Message);
    virtual bool applyCounterSpellSpell(string *Message);
    virtual bool applyDispelMagicSpell(string *Message) = 0;
    virtual bool applyRaiseDeadSpell(string *Message);
    virtual bool applyCureLightWoundsSpell(string *Message);
    virtual bool applyCureHeavyWoundsSpell(string *Message);

    /* Damaging spells */
    virtual bool applyMissileSpell(string *Message);
    virtual bool applyFingerOfDeathSpell(string *Message);
    virtual bool applyLightningBoltSpell(string *Message);
    virtual bool applyCauseLightWoundsSpell(string *Message);
    virtual bool applyCauseHeavyWoundsSpell(string *Message);
    virtual bool applyFireballSpell(string *Message);
    virtual bool applyFireStormSpell(string *Message);
    virtual bool applyIceStormSpell(string *Message);

    /* Enchantments */
    virtual bool applyAmnesiaSpell(string *Message);
    virtual bool applyConfusionSpell(string *Message);
    virtual bool applyCharmPersonSpell(string *Message, 
				       BaseCreature *Source) = 0;
    virtual bool applyCharmMonsterSpell(string *Message,
					BaseCreature *Source) = 0;
    virtual bool applyParalysisSpell(string *Message, BaseCreature *Source);
    virtual bool applyFearSpell(string *Message) = 0;
    virtual bool applyAntiSpell(string *Message) = 0;
    virtual bool applyProtectionFromEvilSpell(string *Message);
    virtual bool applyResistHeatSpell(string *Message);
    virtual bool applyResistColdSpell(string *Message);
    virtual bool applyDiseaseSpell(string *Message);
    virtual bool applyPoisonSpell(string *Message);
    virtual bool applyBlindnessSpell(string *Message) = 0;
    virtual bool applyInvisibilitySpell(string *Message) = 0;
    virtual bool applyHasteSpell(string *Message);
    virtual bool applyTimeStopSpell(string *Message);
    virtual bool applyDelayedEffectSpell(string *Message) = 0;
    virtual bool applyPermanencySpell(string *Message) = 0;

    /* Non spells */
    virtual void applySurrender(string *Message);
    virtual bool applyStab(string *Message);
    virtual int applyMonsterAttack(string *Message, NonWizard *Monster);

    /* Maintenance */
    virtual void decrementCounters();
    // Removes spells that have expired, or only last one turn

    virtual void Reset();

    bool isParalysedNextTurn() const;
    BaseCreature *getParalysisController() const;

private:
    int ID;
    const int damageInflicted;
    int hitPoints;
    const int maxNumHitPoints;
    int state;
    int counterProtFromEvil;
    int counterDisease;
    int counterPoison;
    int counterHaste;
    int counterAmnesia;
    int counterConfusion;
    int counterParalysis;
    string name;

    static int IDCount;
    static map< int, BaseCreature *> IDMap;

    BaseCreature *paralysisController;
};

#endif
