#ifndef _REMOTE_CONNECTION_H
#define _REMOTE_CONNECTION_H

/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/

#include <queue>
using namespace std;

#include "Message.H"
#include "RingBuffer.H"

class RemoteConnection {
public:

    // Thrown on error IO errors
    // Note that the connection automatically disabled before
    // the exception is thrown
    // Disabled connections will not attempt to read or write
    // to the file descriptor
    class ConnectionError {
    public:
	ConnectionError(int Fd, RemoteConnection *Connection, int Error);

	// Get file descriptor that error occurred on
	int getFD() const;

	// Get connection that error occurred on
	RemoteConnection *getConnection() const;
	
	// Get the error number 
	int getErrorNumber() const;
	// if error number is 0 then other end simply closed
	// the connection

    private:
	int fdError;
	RemoteConnection *connection;
	int errNumber;
    };


    enum IOFailureMode {
	DISABLE,
	DISABLE_AND_THROW
    };

    RemoteConnection(int ConnectionFD, 
		     IOFailureMode FailureMode = DISABLE_AND_THROW);

    int getFD() const;

    bool pendingDataToWrite() const;

    bool haveMessageToRead() const;

    Message *getNextMessage();
    // free this memory when you're done with it.
    // don't call it unless you know you have a message ready

    void writeMessage(Message *MsgToSend);
    
    // Read data from connection
    void readData();

    // Write pending data
    void writeData();

    // Disable connection
    void Disable();
    bool isDisabled() const;

    void setFailureMode(IOFailureMode FailureMode);

private:
    bool disabled;
    int connectionFD;
    RingBuffer readRingBuffer;
    RingBuffer writeRingBuffer;
    IOFailureMode failureMode;

    queue<int> msgsToRead;
};


#endif
