/**********************************************************************
   Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**********************************************************************/
#ifndef __PLAYER_INPUT_H
#define __PLAYER_INPUT_H

#include "qhbox.h"
#include "qpushbutton.h"
#include "qpopupmenu.h"
#include <string>
#include <vector>
#include <map>

using namespace std;

class PlayerInput : public QHBox
{
    Q_OBJECT
signals:

    void itemSelected(int);

public:

    PlayerInput(QWidget *Parent, int Margin = 0, int Spacing = -1, 
		const char *Name = 0);

    void SetStateLabel(const QString &Label);

    void SetConfirmState(bool State);

    void SetList(const vector<QString> &List);
    void SetList(const map<QString, int> &List);

private slots:

    void InputSelected(int Id);
    void SelectButtonPushed();
    void ConfirmButtonPushed();

private:
    QPushButton *selectButton;
    QPushButton *confirmButton;
    QPopupMenu *selectMenu;
    vector<QString> selectList;
    map<QString, int> selectMap;
    bool haveList;
    int selectedItem;
    bool confirmState;
    QString selectLabel;
};

#endif
