/*
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/mman.h>

#ifndef MREMAP_MAYMOVE
#define MREMAP_MAYMOVE  1
#define MREMAP_FIXED    2
#endif

int main(int argc, char *argv[])
{
	int fd1;
	int fd2;
	int fd3;
	loff_t size = 4096*1024;
	char *filename1;
	char *filename2;
	char *filename3;
	void *mapped_mem1;
	void *mapped_mem2;
	void *mapped_mem3;
	void *newmem;

	if (argc != 4) {
		fprintf(stderr, "Usage; %s filename1 filename2 filename3\n",
			argv[0]);
		exit(1);
	}

	filename1 = argv[1];
	fd1 = open(filename1, O_RDWR|O_TRUNC|O_CREAT, 0666);
	if (fd1 < 0) {
		fprintf(stderr, "%s: Cannot open `%s': %s\n",
			argv[0], filename1, strerror(errno));
		exit(1);
	}

	printf("%s: expanding `%s' to size %Ld\n", argv[0], filename1, size);
	if (ftruncate(fd1, size) < 0) {
		perror("ftruncate");
		exit(1);
	}
	mapped_mem1 = mmap(0, size, PROT_READ|PROT_WRITE, MAP_SHARED, fd1, 0);
	if (mapped_mem1 == MAP_FAILED) {
		perror("mmap");
		exit(1);
	}
	printf("dirtying %Ld bytes of memory\n", size);
	memset(mapped_mem1, 0, size);
	msync(mapped_mem1, size, MS_SYNC);


	filename2 = argv[2];
	fd2 = open(filename2, O_RDWR|O_TRUNC|O_CREAT, 0666);
	if (fd2 < 0) {
		fprintf(stderr, "%s: Cannot open `%s': %s\n",
			argv[0], filename2, strerror(errno));
		exit(1);
	}

	printf("%s: expanding `%s' to size %Ld\n", argv[0], filename2, size);
	if (ftruncate(fd2, size) < 0) {
		perror("ftruncate");
		exit(1);
	}
	mapped_mem2 = mmap(0, size, PROT_READ|PROT_WRITE, MAP_SHARED, fd2, 0);
	if (mapped_mem2 == MAP_FAILED) {
		perror("mmap");
		exit(1);
	}
	printf("dirtying %Ld bytes of memory\n", size);
	memset(mapped_mem2, 0, size);
	msync(mapped_mem2, size, MS_SYNC);

	filename3 = argv[3];
	fd3 = open(filename3, O_RDWR|O_TRUNC|O_CREAT, 0666);
	if (fd3 < 0) {
		fprintf(stderr, "%s: Cannot open `%s': %s\n",
			argv[0], filename3, strerror(errno));
		exit(1);
	}

	printf("%s: expanding `%s' to size %Ld\n", argv[0], filename3, size);
	if (ftruncate(fd3, size) < 0) {
		perror("ftruncate");
		exit(1);
	}
	mapped_mem3 = mmap(0, size, PROT_READ|PROT_WRITE, MAP_SHARED, fd3, 0);
	if (mapped_mem3 == MAP_FAILED) {
		perror("mmap");
		exit(1);
	}
	printf("dirtying %Ld bytes of memory\n", size);
	memset(mapped_mem3, 0, size);
	msync(mapped_mem3, size, MS_SYNC);

	newmem = mremap(mapped_mem2, size, size*2, MREMAP_MAYMOVE);

	printf("mapped_mem1=%p\n", mapped_mem1);
	printf("mapped_mem2=%p\n", mapped_mem2);
	printf("mapped_mem3=%p\n", mapped_mem3);
	printf("newmem=%p\n", newmem);

	exit(0);
}
