#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/poll.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/types.h>
#include <errno.h>
#include <signal.h>
#include <sched.h>

#define MAX_PROCESSES	128
#define MAX_PIPES	32768

struct pollfd g_ppfd[MAX_PROCESSES][MAX_PIPES];
int wfds[MAX_PROCESSES][MAX_PIPES];
int childs[MAX_PROCESSES];

int main(int argc, char **argv)
{
	int handles, processes, loops;
	int i, j, l;
	char buf[1];

	printf("POLLBENCH <handles> <processes> <loops>\n");

	if (argc != 4)
		return 1;
	handles = atoi(argv[1]);
	processes = atoi(argv[2]);
	loops = atoi(argv[3]);
	printf("handles %d processes %d loops %d.\n", handles, processes, loops);
	if (handles < 1 || handles >= MAX_PIPES || processes < 2 || processes > MAX_PROCESSES || loops < 1) {
		return 4;
	}

	if(geteuid()==0 && handles*processes > 500) {
		struct rlimit newlimit;
		int ret;

		printf("Trying to increase RLIMIT_NOFILE.\n");
		newlimit.rlim_cur = 2*handles*processes+200;
		newlimit.rlim_max = 2*handles*processes+200;
		ret = setrlimit(RLIMIT_NOFILE,&newlimit);
		printf("setrlimit returned %d, errno %d.\n",ret, errno);
	}

	for (i=0;i<processes;i++) {
		for (j=0;j<handles;j++) {
			int pfd[2];

			if (pipe(pfd) != 0) {
				fprintf(stderr, "pipe %d/%d failed with errno %d.\n", i, j, errno);
				return 3;
			}
			g_ppfd[i][j].fd = pfd[0];
			g_ppfd[i][j].events = POLLIN;
			wfds[i][j] = pfd[1];
		}
	}
	for (i=1;i<processes;i++) {
		childs[i] = fork();
		if (childs[i] < 0) {
			fprintf(stderr, "fork() failed, errno %d.\n", errno);
			return 3;
		}
		if (childs[i] == 0)
			break;
		sched_yield();
	}
	if (i==processes)
		i = 0;
	{
		unsigned long long actual;
		struct timeval tvstart;
		struct timeval tvend;

		if (i==0) {
			sched_yield();
			gettimeofday(&tvstart,NULL);
			write(wfds[1][handles/2], buf, 1);
		}
		
		for(l=0;i!=0||l<loops;l++) {
			poll(g_ppfd[i], handles, -1);
			for (j=0;j<handles;j++) {
				if (g_ppfd[i][j].revents) {
					read(g_ppfd[i][j].fd, buf, 1);
					write(wfds[(i+1)%processes][j], buf, 1);
				}
			}
		}
		gettimeofday(&tvend,NULL);
		actual = tvend.tv_sec*1000*1000+tvend.tv_usec;
		actual -= tvstart.tv_sec*1000*1000+tvstart.tv_usec;
		printf("result with handles %d processes %d loops %d:", handles, processes, loops);
		printf("time %9.6f sec.\n", actual/1E6);
	}
	for (i=1;i<processes;i++) {
		kill(childs[i], SIGTERM);
		sched_yield();
	}
	return 0;
}
