/*
 * Keep redirtying a file's pages
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>

int main(int argc, char *argv[])
{
	char *filename;
	unsigned long nmegs;
	int fd;
	loff_t size;

	if (argc != 3) {
		fprintf(stderr,
			"Usage: %s filename nmegs\n",
			argv[0]);
		exit(1);
	}

	filename = argv[1];
	nmegs = atoi(argv[2]);
	fd = open(filename, O_RDWR|O_CREAT|O_TRUNC, 0666);
	if (fd < 0) {
		fprintf(stderr, "%s: cannot create %s: %s\n",
			argv[0], filename, strerror(errno));
		exit(1);
	}

	size = nmegs;
	size *= 1024 * 1024;

	for ( ; ; ) {
		loff_t off;
		char c = 0;

		for (off = 0; off < size; off += 4096) {
			if (pwrite(fd, &c, 1, off) != 1) {
				perror("pwrite");
				exit(1);
			}
		}
	}
}
