#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include "slacker.h"

char *ourname;
char _meg[1024*1024 + 40960];
int do_fsync = 0;
unsigned align_offset = 0;
int o_streaming;
int blocksize = 0;

int nbytes = 1;
int offset = 0;
int k = 1;
char *write_buffer;

static void usage(void)
{
	fprintf(stderr,
		"Usage: %s [-k] [-n nbytes] [-o offset] depth files-per-dir\n",
		ourname);
	exit(1);
}

static void doit(int depth, int fpd)
{
	int i;

	for (i = 0; i < fpd; i++) {
		char buf[100];
		sprintf(buf, "%08d", i);

		if (depth) {
			mkdir(buf, 0777);
			chdir(buf);
			doit(depth - 1, fpd);
			chdir("..");
		} else {
			int fd = creat(buf, 0666);

			if (fd < 0) {
				perror("creat");
				exit(1);
			}
			lseek(fd, offset, SEEK_SET);
			write(fd, write_buffer, nbytes);
			close(fd);
		}
	}
}

int main(int argc, char *argv[])
{
	int depth = 0;
	int fpd = 0;
	int c;

	ourname = argv[0];

	if (argc < 2)
		usage();

	while ((c = getopt(argc, argv, "kn:o:")) != -1) {
		switch (c) {
		case 'k':
			k = 1000;
			break;
		case 'n':
			nbytes = strtol(optarg, NULL, 10);
			break;
		case 'o':
			offset = strtol(optarg, NULL, 10);
			break;
		default:
			usage();
		}
	}

	if (optind == argc)
		usage();
	depth = atoi(argv[optind++]);
	if (optind == argc)
		usage();
	fpd = atoi(argv[optind++]);
	if (optind != argc)
		usage();
	nbytes *= k;
	offset *= k;
	write_buffer = malloc(nbytes);
	doit(depth, fpd);
	exit(0);
}
