/*
 * Turn off writes to a disk at the submit_bh() level.
 *
 * Need I point out the obvious?
 *
 * 17May01	Andrew Morton <andrewm@uow.edu.au>
 *	Created
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/errno.h>
#include <sys/fcntl.h>
#include <linux/kdev_t.h>

static const char procfile[] = "/proc/sys/fs/jbd-no-write";

static void usage(void)
{
	fprintf(stderr, "Usage: no-write-to /dev/victim - disable writes to device\n");
	fprintf(stderr, "       no-write-to             - enable writes again\n");
	exit(1);
}

int main(int argc, char *argv[])
{
	char *victim;
	struct stat statbuf;
	char buf[32];
	int fd;
	unsigned int dev_no;

	if (argc > 2)
		usage();

	fd = open(procfile, O_RDWR);
	if (fd < 0) {
		fprintf(stderr, "%s: cannot open `%s' for reading: %s\n",
			argv[0], procfile, strerror(errno));
		exit(1);
	}

	if (argc == 1) {
		strcpy(buf, "0");
		printf("enabling writes\n");
	} else {
		victim = argv[1];
		if (stat(victim, &statbuf) < 0) {
			fprintf(stderr, "%s: error statting `%s': %s\n",
				argv[0], victim, strerror(errno));
			exit(1);
		}
		dev_no = statbuf.st_rdev;

		printf("%s: turning off writes to %s (%02d:%02d)\n",
			argv[0], victim, MAJOR(dev_no), MINOR(dev_no));

		sprintf(buf, "%u", 0xdead0000 + dev_no);
	}

	if (write(fd, buf, strlen(buf)) != strlen(buf)) {
		fprintf(stderr, "%s: error writing to `%s': %s\n",
			argv[0], procfile, strerror(errno));
		exit(1);
	}
	close(fd);
	exit(0);
}

