#!/bin/sh
#
# add-to-kernel.sh 
#
# Applies the individual patches for ext3
#
# Usage: add-to-kernel.sh manifest-file name_of_patched_kernel_tree
#
# Must be run from the root of the ext3 CVS tree.  Uses patches in
# ./patches
#
# Assumes that the kernel tree and the ext3 CVS tree both live
# in the same directory (eg: /usr/src)

usage()
{
	echo Usage: add-to-kernel.sh manifest-file name_of_patched_kernel_tree
	exit 1
}

wantdir()
{
	if [ ! -d $1 ]
	then
		echo $1: no directory by that name in $(/bin/pwd)
		exit 1
	fi
}

can_apply()
{
	if patch -s -p1 --dry-run -i "$1" -f
	then
		return 0
	else
		return 1
	fi
}

do_apply()
{
	if patch -p1 -i "$1"
	then
		true
	else
		echo SOMETHING WENT WRONG
		exit 1
	fi
}

if [ $# != 2 ]
then
	usage
fi

#
# Initialise and check stuff
#
EXT3_CVS_DIR=$(/bin/pwd)
FILES_TO_LINK=$(cat $1)
PATCHED_KERNEL_TREE=$2
cd ..
wantdir $PATCHED_KERNEL_TREE
must_abort=0

#
# OK, the patches will apply.  Now see if we can link the whole files
#
cd $EXT3_CVS_DIR
for i in $FILES_TO_LINK
do
	cd $EXT3_CVS_DIR
	if [ -e $i ]
	then
		#
		# The file exists in the CVS tree
		#
		cd ../$PATCHED_KERNEL_TREE
		if [ -e $i ]
		then
			echo Will overwrite $PATCHED_KERNEL_TREE/$i
		fi
	fi
done

if [ $must_abort = 1 ]
then
	echo Aborting
	exit 1
fi

#
# And link the files
#
cd $EXT3_CVS_DIR
cd ../$PATCHED_KERNEL_TREE
mkdir -p fs/ext3 fs/jbd
for i in $FILES_TO_LINK
do
	cd $EXT3_CVS_DIR
	if [ -e $i ]
	then
		#
		# The file exists in the CVS tree
		#
		cd ../$PATCHED_KERNEL_TREE
		echo symlinking $i
		ln -nfs $EXT3_CVS_DIR/$i $i
	fi
done

echo
echo Successfully applied ext3 to ../$PATCHED_KERNEL_TREE
