#include <stdio.h>
#include <stdlib.h>
#include "tclient.h"
#include "tetris.h"
#include "field.h"

static const int sb_in_friend_field[] = {
  0, 0, 0, 0, 0, 0,
  10,  /* Add Line */
  10,  /* Clear Line */
  50,  /* Nuke Field */
  20,  /* Clear Random Blocks */
  50,  /* Switch Fields */
  10,  /* Clear Special Blocks */
  50,  /* Block Gravity */
  20,  /* Blockquake */
  -5   /* Block Bomb */
};

static const int sb_in_foe_field[] = {
  0, 0, 0, 0, 0, 0,
  50,  /* Add Line */
  50,  /* Clear Line */
  300, /* Nuke Field */
  50,  /* Clear Random Blocks */
  300, /* Switch Fields */
  10,  /* Clear Special Blocks */
  300, /* Block Gravity */
  100, /* Blockquake */
  50   /* Block Bomb */
};

void show_field(signed char *field, int block, int orient, int bx, int by) {
  int i, j;

  if (!field) {
    printf("field is NULL\n");
    return;
  }

  for (i = 0; i < TC_FIELD_HEIGHT; i++) {
    printf("%2d   |", i);
    for (j = 0; j < TC_FIELD_WIDTH; j++) {
      if (block >= 0 &&
          j - bx >= 0 && j - bx <= 3 &&
          i - by >= 0 && i - by <= 3 &&
          blocks[block][orient][i - by][j - bx]) {
        printf("%%%%");
      } else if (field[i * TC_FIELD_WIDTH + j] == 0) {
        printf("  ");
      } else if (field[i * TC_FIELD_WIDTH + j] < TC_SPECIAL_FIRST_SPECIAL) {
        printf("XX");
      } else {
        printf("%02i", field[i*TC_FIELD_WIDTH+j]);
      }
    }
    printf("|\n");
  }
}

/* calculate the score of a field; friend_or_foe must be +1 for
 * friend, -1 for foe
 */
int eval_field(signed char *field, int friend_or_foe) {
  int x, y;
  int points = 0;
  const int *sb_points = friend_or_foe > 0
                         ? sb_in_friend_field
                         : sb_in_foe_field;

#if 0
  /* easy-to-read version */
  for (y = 0; y < TC_FIELD_HEIGHT; y++) {
    for (x = 0; x < TC_FIELD_WIDTH; x++) {
      if (fblock(field, x, y)) {
        if (y < TC_FIELD_HEIGHT - 1) {
          /* penalty for height */
          points += y - 21;
          /* penalty for holes (less penalty the higher we go) */
          if (!fblock(field, x, y + 1)) {
            points -= y / 4 + 1;
          }
        }
        /* bonus for special blocks */
        if (fblock(field, x, y) >= TC_SPECIAL_FIRST_SPECIAL) {
          points += sb_points[(int)fblock(field, x, y)];
        }
      }

      /* penalty for horizontal "holes" */
      if (x < TC_FIELD_WIDTH - 1 &&
          !fblock(field, x, y) != !fblock(field, x + 1, y)) {
        points--;
      }
    }
  }
#else
  /* unrolled version (make the x & y loops finish one block early so
   * the hole tests don't have to check if they're at the edge) (makes
   * eval_field() run 40% faster and hence find_moves() runs 10%
   * faster)
   */
  for (y = 0; y < TC_FIELD_HEIGHT - 1; y++, field += TC_FIELD_WIDTH) {
    for (x = 0; x < TC_FIELD_WIDTH - 1; x++) {
      if (field[x]) {
        /* penalty for height */
/*        points += y - 21; */
        /* penalty for holes (less penalty the higher we go) */
        if (!field[x + TC_FIELD_WIDTH]) {
          points -= y / 4 + 1;
        }
        /* bonus for special blocks */
        if (field[x] >= TC_SPECIAL_FIRST_SPECIAL) {
          points += sb_points[(int)field[x]];
        }
      }

      /* penalty for horizontal "holes" */
      if (!field[x] != !field[x + 1]) {
        points--;
      }
    }
    if (field[x]) {
      /* penalty for height */
/*      points += y - 21; */
      /* penalty for holes (less penalty the higher we go) */
      if (!field[x + TC_FIELD_WIDTH]) {
        points -= y + 1;
      }
      /* bonus for special blocks */
      if (field[x] >= TC_SPECIAL_FIRST_SPECIAL) {
        points += sb_points[(int)field[x]];
      }
    }
  }
  for (x = 0; x < TC_FIELD_WIDTH - 1; x++) {
    /* bonus for special blocks */
    if (field[x] > TC_SPECIAL_FIRST_SPECIAL) {
      points += sb_points[(int)field[x]];
    }

    /* penalty for horizontal "holes" */
    if (!field[x] != !field[x + 1]) {
      points--;
    }
  }
  /* bonus for special blocks */
  if (field[x] > TC_SPECIAL_FIRST_SPECIAL) {
    points += sb_points[(int)field[x]];
  }

#endif

  return points * friend_or_foe;
}
