#include <malloc.h>
#include <stdio.h>
#include "TetrinetField.h"
#include "blockmap.h"
#include "rotation.h"

static char testField[]=
"............"
"............"
"............"
"............"
"............"
"............"
"............"
"............"
"............"
"............"
"............"
"............"
"............"
"............"
"............"
"eee........."
"e..........."
"eeee........"
"eeddd......."
"eeffd.....c."
"ccdffeeec.cc"
"ccddde.cccc.";


int main()
{
	setupTables();
	char *field=(char *)calloc(TC_FIELD_HEIGHT*TC_FIELD_WIDTH, 1);
	TetrinetField j(field);
	for(int y=0;y<TC_FIELD_HEIGHT;y++)
		for(int x=0;x<TC_FIELD_WIDTH;x++)
		{
			if(testField[y*TC_FIELD_WIDTH+x]=='.')
				field[y*TC_FIELD_WIDTH+x]=0;
			else
				field[y*TC_FIELD_WIDTH+x]=testField[y*TC_FIELD_WIDTH+x]-'a';
		}
		

	BlockStatus t;
	t.type=5;
	t.x=7;
	t.y=0;

	j.printField();
		
	int q=j.simulateDrop(t, t.x);
	printf("%d\n", q);
	printf("\n\n--------\n\n");
	j.printField();
}
