/* Downfall - A tetrinet AI
 * Copyright (C) 2003-2004 Jonathan Gray
 * Copyright (C) 2003-2004 Nathan Parslow
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: main.c,v 1.29 2004/01/16 00:51:04 khalek Exp $ 
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#include "speshal.h"
#include "tclient.h"
#include "tetris.h"
#include "util.h"

#define defaultBotName "Downfall"
char *botName = NULL;
#define teamName ""
#define channel ""

char *server = NULL; /* defaults to localhost */
int port = -1; 	     /* defaults to 9467 */

/**
 * connect to server
 */
void joinServer() {
	if (server == NULL) {
		server = (char *) malloc(10);
		strcpy(server, "localhost");
	}

	if (port == -1) {
		port = 9467;
	}

	debug(1, "Connecting to server %s:%d\n", server, port);

	if (connectToServer(server, port, botName, teamName, channel) < 0) {
		debug(1, "error: %s\n", tc_error_string);
		exit(1);
	} else {
		debug(1, "success\n");
	}

	free(server);
}

/**
 * print usage
 */
void usage() {
	fprintf(stderr, "usage: downfall [OPTIONS]\n");
	fprintf(stderr, "  -h SERVER\tConnect to specified server (default: localhost)\n");
	fprintf(stderr, "  -d INT\tSet debug level\n");
	fprintf(stderr, "  -n NAME\tSet name of AI\n");
	fprintf(stderr, "  -p INT\tConeect to specified port on server (default: 9467)\n");
	fprintf(stderr, "  -v\t\tDisplay version information\n");
}

/* check command line params */
void parseCmdLine(int argc, char *argv[]){
	int i;
	int ch;

	while ((ch = getopt(argc, argv, "d:h:n:p:v")) != -1) {
		switch (ch) {
		case 'h':
			server = (char *) malloc(strlen(optarg));
			strcpy(server, optarg);
			break;
		case 'd':
			debugLevel = atoi(optarg);
			debug(1, "Debug level: %d\n", debugLevel);
			break;
		case 'n':
			botName = (char *) malloc(strlen(optarg));
			strcpy(botName, optarg);
			break;
		case 'p':
			port = atoi(optarg);
			break;
		case 'v':
			printf("downfall: built on %s %s\n", __DATE__, __TIME__);
			exit(1);
			break;
		default:
			usage();
			exit(1);
		}
	}
}


/**
 * main loop, does:
 *
 * Wait for piece.
 * Place piece
 * Use specials
 *
 */
void gameLoop()
{
	struct TC_GameData *gdata;

	int blockType, x, y;
	int status;
	/* session loop */
	while (1)
	{

		debug(1, "waiting for game to start\n");
		if (Start(&gdata) != 0)
		{
			debug(1, "Game start failed\n");
			exit(1);
		}
		else
		{
			debug(1, "Game starting\n");
		}
		/* individual game loop */
		do
		{
			usleep(20000);
			status = GetCurrentBlock(&blockType, &x, &y);
			if(blockType != TC_BLOCK_NONE)
			{
				debug(1, "Got block %i\n", blockType);

				placePiece(gdata);
				useSpeshals(gdata);
			}
			status = GetCurrentBlock(&blockType, &x, &y);
		}while(!status);

		if (status == 1) /* lose */
			debug(1, "lost :/\n");
		else if (status == 2) /* win */
			debug(1, "Champeen!\n");
	}
}

/**
 * get args, join server, run game.
 */
int main(int argc, char *argv[]) {
	parseCmdLine(argc, argv);
	if (botName == NULL)
	{
		botName = (char *) malloc(strlen(defaultBotName));
		strcpy(botName, defaultBotName);
	}
	joinServer();
	srand(time(NULL));
	gameLoop();
	return 0;
}
