// gencore, a program to test run bots for Tetrinet.
// Copyright (C) 2004, Jonathan Wheare.
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
                                                                                
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "bot.hpp"

#define NUMBER_OF_BOTS 5
#define NUMBER_OF_GENOMES 30
#define NUMBER_OF_PASSES 12
struct genome_struct
{
	public:
	char *username;
	bot *ai_bot;
	//int pipefd[2];
	float genome[6];
	int result;
	bool is_running;
	bool has_run;
	pid_t pid;
};
	
FILE * outputfile;
int result;
int status;
int running_processes;
int number_of_run_genomes;
pid_t pid;

genome_struct *genome[NUMBER_OF_GENOMES];

int compar(const void *p1, const void *p2)
{
	genome_struct *c1 = *(genome_struct **)p1;
	genome_struct *c2 = *(genome_struct **)p2;
	cout<<"sort result: "<<c2->result<<" , "<<c1->result<<endl;
	return((c2->result) - (c1->result));
}
void sort_genome()
{
	qsort(genome,NUMBER_OF_GENOMES,sizeof(genome_struct *),compar);
}

void init_child(genome_struct *child,int num)
{
	//child = new genome_struct;
	child->username = new char[20];
	sprintf(child->username,"bot%d",num);
	child->result = 0;
	child->has_run = false;
}

void reset_genomes()
{
	for(int i = 0;i<NUMBER_OF_GENOMES;i++)
	{
		genome[i]->has_run = false;
		
	}
	number_of_run_genomes = 0;
}
void zero_genomes()
{
	for(int i = 0;i<NUMBER_OF_GENOMES;i++)
	{
		genome[i]->result = 0;
		
	}
}


pid_t fork_genome(genome_struct* gen)
{
	pid_t pid;
	gen->is_running = true;
	gen->has_run = true;
	pid = fork();
	if(pid == 0)
	{
		char buf[30];
		sprintf(buf,"%s.bot",gen->username);
		FILE *botoutput = fopen(buf,"w");
		//int pipefd_write = open("fuzfifo",O_NONBLOCK |  O_WRONLY);
		cout<<"ptang!"<<endl;
		gen->result = -1;
		gen->is_running = true;
		gen->ai_bot = new bot;
		gen->ai_bot->username = gen->username;
		cout<<"ptang!"<<endl;
		//write(pipefd_write,"ptang",sizeof("ptang"));
		gen->ai_bot->gap_score =-gen->genome[0];
		gen->ai_bot->side_score =gen->genome[1];
		gen->ai_bot->height_score =gen->genome[2];
		gen->ai_bot->field_gap_score =-gen->genome[3];
		gen->ai_bot->full_line_score =gen->genome[4];
		if (gen->ai_bot->connect() != 0)
		{
			cout<<"failed to connect"<<endl;
			exit(1);
		}
		cout<<"connected"<<endl;
		if (gen->ai_bot->wait_for_start() != 0)
		{
			cout<<"failed to start"<<endl;
			exit(1);
		}
		cout<<"started"<<endl;
		cout<<"ptang!"<<endl;
		while (gen->ai_bot->status != edead)
		{
			gen->ai_bot->play();
			//write(pipefd_write,"loop",sizeof("loop"));
		}
		
		gen->result = gen->ai_bot->iterations / 10;
		if (gen->result > 100) 
		{
			gen->result = 100;
		}
		if(gen->ai_bot->result == 2)
		{
			gen->result = gen->result + 50;
		}
		fprintf(botoutput,"%s score %d\n",gen->username,gen->result);
		fclose(botoutput);
		delete gen->ai_bot;
		gen->is_running = false;
		cout<<"ended."<<endl;
		exit(gen->result);
	}
	if(pid <0)
	{
		cout<<"fork failed"<<endl;
		return(pid);
	}
	gen->pid = pid;
	running_processes++;
	return(pid);
}

void mate_genomes(genome_struct *gen1, genome_struct *gen2, genome_struct *result_gen)
{
	for(int i = 0; i<6;i++)
	{
		if(random() % 1 == 0)
		{
			result_gen->genome[i] = gen1->genome[i];
		}
		else
		{
			result_gen->genome[i] = gen2->genome[i];
		}
	}
}	

void mutate_genome(genome_struct *gen)
{
	for(int i = 0; i<6;i++)
	{
		if(random() % 5 == 0)
		{
			gen->genome[i] = gen->genome[i] * ((50 + random() % 100)/100);
		}
	}
}

pid_t fork_bot(char *bot)
{
	pid_t pid;
	pid = fork();
	if(pid == 0)
	{
		result = system(bot);
		return(0);
	}
	if(pid <0)
	{
		cout<<"fork failed"<<endl;
		return(pid);
	}
	return(pid);
}

void random_genome(genome_struct *child)
{
	for (int i = 0;i<5;i++)
	{
		child->genome[i]=(random()%100);
	}
}


void run_genome()
{
	//int pipefd_read = open("fuzfifo",O_NONBLOCK |  O_RDONLY);
	int genome_number =0;
	while (number_of_run_genomes < NUMBER_OF_GENOMES && running_processes < NUMBER_OF_BOTS)
	{
		//cout<<"genome number1: "<<genome_number<<endl;
		genome_number = random() % (NUMBER_OF_GENOMES);
		{
			//cout<<"genome number2: "<<genome_number<<endl;
			while (genome[genome_number]->has_run != false)
			{
				//cout<<"genome number3: "<<genome_number<<endl;
				genome_number = random() % (NUMBER_OF_GENOMES);
			}
			//cout<<"genome number4: "<<genome_number<<endl;
		}
		//cout<<"pting!"<<endl;
		number_of_run_genomes++;
		fork_genome(genome[genome_number]);
	}
		
	while(running_processes > 0)
	{
		char buf[30];
		//bool flag = tr
		/*pid = waitpid(0,&status,WNOHANG);
		while( pid == 0)
		{
			if(read(pipefd_read,buf,30) != -1)
			{
				cout<<"from pipe: "<<buf<<endl;
			}
			sleep(1);
			
		}*/
		
		pid = wait(&status);
		running_processes--;
		cout<<"exit pid: "<<pid<<endl;
		for(int j = 0;j<NUMBER_OF_GENOMES;j++)
		{
			if (genome[j]->pid == pid)
			{
				genome[j]->is_running = false;
				genome[j]->has_run = true;
				/*if(WIFEXITED(status))
				{
					genome[j]->result =  WEXITSTATUS(status);
					cout<<"exit O.K"<<endl;
				}
				else
				{
					genome[j]->result = -1;
							
				}*/
			}
		}
	}
	//close(pipefd_read);
}

void read_bot_files()
{
	FILE *botinputfile;
	char buf[30];
	int bot,result;
	for(int i =0; i< NUMBER_OF_GENOMES;i++)
	{
		sprintf(buf,"bot%d.bot",i);
		botinputfile = fopen(buf,"r");
		fscanf(botinputfile,"bot%d score %d\n",&bot,&result);
		genome[i]->result = genome[i]->result + result;
		fclose(botinputfile);
	}
}

int main()
{
	
	
	number_of_run_genomes = 0;
	char buf[30];
	srandom(time(NULL));
	outputfile = fopen("fuzout.txt","w");
	for(int i = 0;i<NUMBER_OF_GENOMES;i++)
	{
		cout<<"init genome "<<i<<endl;
		genome[i]= new genome_struct;
		init_child(genome[i],i);
		random_genome(genome[i]);
		//fork_child(genome[i]);
	}
	for(int run = 0; run < NUMBER_OF_PASSES; run++)
	{
		for(int i =0; i<3;i++)
		{
			while(number_of_run_genomes < NUMBER_OF_GENOMES)
			{
				run_genome();
			}
			read_bot_files();
			reset_genomes();
		}
		sort_genome();
		for(int j = 0;j<NUMBER_OF_GENOMES;j++)
		{
			cout<<"Bot number: "<<j<<"pid: "<<genome[j]->pid<<" exit status: "<<genome[j]->result<<endl;
		}				
		fprintf(outputfile,"run %d\n",run);
		for(int j = 0;j<NUMBER_OF_GENOMES;j++)
		{
			//cout<<"Bot number: "<<j<<"pid: "<<genome[j]->pid<<" exit status: "<<genome[j]->result<<endl;
			fprintf(outputfile,"Bot no. %d score %d ",j,genome[j]->result);
			for(int k = 0;k<6;k++)
			{
				fprintf(outputfile,"%f ",genome[j]->genome[k]);
			}
			fprintf(outputfile,"\n");			
		}
		fprintf(outputfile,"\n");
		for(int j = (NUMBER_OF_GENOMES *0.75) ; j<NUMBER_OF_GENOMES;j++)
		{
			int bot1 = random() % (NUMBER_OF_GENOMES/2);
			int bot2 = random() % (NUMBER_OF_GENOMES/2);
			while (bot1 == bot2)
			{
				bot1 = random() % (NUMBER_OF_GENOMES/2);
			    bot2 = random() % (NUMBER_OF_GENOMES/2);
			}
			mate_genomes(genome[bot1],genome[bot2],genome[j]);
		}
		for(int j = (NUMBER_OF_GENOMES *0.25) ; j<NUMBER_OF_GENOMES;j++)
		{
			mutate_genome(genome[j]);
		}
		zero_genomes();
	}
	
	fclose(outputfile);
}
