#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <termios.h>

#include "tclient.h"
#include "btetris.h"

int VAR_SWITCH_THRESHOLD=20;


// The weight given to buried holes when determining a field value
int VAR_WEIGHTING_BURIED_HOLES=250;
int VAR_WEIGHTING_BURIED_HOLES_ORIG=250;

float g_shadowedHolesWeight_orig = -0.65f;
float g_shadowedHolesWeight = -0.65f;
float g_pileHeightWeight = -0.10f;
float g_sumOfWellHeightsWeight = -0.20f;
int g_set_up_gravity_tetris = 0;
extern int setting_up_switch;


float FieldMerit(FIELD field, int *field_height) 
{
  float field_merit;
  field_merit = (float)tetris_total_shadowed_holes(field) * g_shadowedHolesWeight;
  field_merit += (float)tetris_pile_height_weighted_cells(field) * g_pileHeightWeight;
  field_merit += (float)tetris_sum_of_well_heights(field) * g_sumOfWellHeightsWeight;

  if (field_height) {
    *field_height = tetris_field_height(field);
  }

  return field_merit;
}

int GetBlockBombValue(FIELD field) 
{
		int num_block_bombs = 0;
		int x,y,i,j;
    if(field)
    {
  		for(x = 0; x < TC_FIELD_WIDTH; x++)
		  {
    		for(y = 0; y < TC_FIELD_HEIGHT; y++)
				{
		      if(field[y][x] == TC_SPECIAL_BLOCK_BOMB)
    		  {
       			printf("starting block count-");
		        for(j = ((y > 0) ? y - 1 : 0); j <= ((y < TC_FIELD_HEIGHT - 1) ? y + 1 : TC_FIELD_HEIGHT - 1); j++)
    	      {
      	      for(i = ((x > 0) ? x - 1 : 0); i <= ((x < TC_FIELD_WIDTH - 1) ? x + 1 : TC_FIELD_WIDTH - 1); i++)
        	    {
          	    if(field[j][i] != 0 && field[j][i] < TC_SPECIAL_FIRST_SPECIAL)
            	  {
              	  num_block_bombs++;
              	}
            	}
          	}
          	printf("blocks found = %d\n", num_block_bombs);
        	}
      	}
			}
		}
		return num_block_bombs;
}

int tetris_total_shadowed_holes(FIELD field)
{
  int totalShadowedHoles = 0;
  int x, y;
  int encounteredOccupiedCell;

  for(x = 0; x < TC_FIELD_WIDTH; x++)
  {
    encounteredOccupiedCell = 0;
    for(y = 0; y < TC_FIELD_HEIGHT; y++)
    {
      if(field[y][x])
        encounteredOccupiedCell = 1;
      else {
        if(encounteredOccupiedCell) 
          totalShadowedHoles++;
      }
    }
  }

  return totalShadowedHoles;
}


int tetris_field_height(FIELD field)
{
	int x,y;
  for(y = 0; y < TC_FIELD_HEIGHT; y++)
    for(x = 0; x < TC_FIELD_WIDTH; x++)
      if(field[y][x])
        return TC_FIELD_HEIGHT - y;

  return 0;
}

int tetris_pile_height_weighted_cells(FIELD field)
{
  int x, y;
  int totalWeightedCells = 0;


  for(y = TC_FIELD_HEIGHT - 1; y >= 0; y--)
  {
    for(x = 0; x < TC_FIELD_WIDTH; x++)
    {
      if(field[y][x])
        totalWeightedCells += (TC_FIELD_HEIGHT - y);
    }
  }

  return totalWeightedCells;
}

int tetris_column_height(FIELD field, int column)
{
  int y;

  for(y = 0; y < TC_FIELD_HEIGHT; y++)
  {
    if(field[y][column])
      return TC_FIELD_HEIGHT - y;
  }

  return 0;
}

int tetris_sum_of_well_heights(FIELD field)
{
  int sumOfWellHeights = 0;
  int columnHeight = 0;
  int columnHeightToLeft = 0;
  int columnHeightToRight = 0;
  int x;


  columnHeight = tetris_column_height(field, 0);
  columnHeightToRight = tetris_column_height(field, 1);
  if(columnHeightToRight > columnHeight)
    sumOfWellHeights += (columnHeightToRight - columnHeight);


  if(!g_set_up_gravity_tetris)
  {
  columnHeight = tetris_column_height(field, TC_FIELD_WIDTH - 1);
  columnHeightToLeft = tetris_column_height(field, TC_FIELD_WIDTH - 2);
  if(columnHeightToLeft > columnHeight)
    sumOfWellHeights += (columnHeightToLeft - columnHeight);
  }

  for(x = 1; x < TC_FIELD_WIDTH - 1; x++)
  {
    columnHeightToLeft = tetris_column_height(field, x - 1);
    columnHeight = tetris_column_height(field, x);
    columnHeightToRight = tetris_column_height(field, x + 1);

    if(columnHeightToLeft > columnHeightToRight)
      columnHeightToLeft = columnHeightToRight;
    else
      columnHeightToRight = columnHeightToLeft;

    if(columnHeightToLeft > columnHeight)
      sumOfWellHeights += columnHeightToLeft - columnHeight;
  }

  return sumOfWellHeights;
}


float GetBestMove(int *blocks, int num_blocks, FIELD field, int *best_position, int *best_orientation)
{
  FIELD tmp_field;
  int x = 4, y = 0;
  int min_x, maxx;
  int current_best_position = 0;
  int current_best_orientation = 0;
  float current_best_merit = (-1.0e20f);
  int lines_eliminated = 0;

  int trial_position = 0;
  int trial_orientation = 0;
  float trial_merit = 0.0f;

  int next_block_best_position;
  int next_block_best_orientation;

  int block;

  if(field == NULL)
    return 0.0;

  block = *blocks;

  for(trial_orientation = 0; trial_orientation < num_rotations_for_blocktype(block); trial_orientation++)
  {
   // need to also check if block is obstructed by other blocks
 //   get_valid_x_positions(block, trial_orientation, &min_x, &maxx);

    get_possible_block_x_positions(field, block, trial_orientation, x, y + 1, &min_x, &maxx);

    if(g_set_up_gravity_tetris && block != 0) {	
			printf("Setting up a grav tetty in getMove.c\n");
      maxx--;
		}
		
    for(trial_position = min_x; trial_position <= maxx; trial_position++)
    {
      memcpy(tmp_field, field, TC_FIELD_SIZE);

      set_current_block(block, trial_orientation, trial_position, 0);
      tetris_blockdrop(tmp_field);
      tetris_solidify(tmp_field);

      if(num_blocks == 1)
      {
        lines_eliminated = tetris_removelines(NULL, tmp_field);
        trial_merit = 0;

        if(lines_eliminated == 1)
          trial_merit -= 10;
         
        if(!g_set_up_gravity_tetris)
          trial_merit += (float)tetris_total_shadowed_holes(tmp_field) * g_shadowedHolesWeight;

        trial_merit += (float)tetris_pile_height_weighted_cells(tmp_field) * g_pileHeightWeight;
        trial_merit += (float)tetris_sum_of_well_heights(tmp_field) * g_sumOfWellHeightsWeight;

        if(setting_up_switch)
          trial_merit = -trial_merit;


      } else {
        trial_merit = GetBestMove(&(blocks[1]), num_blocks - 1, tmp_field, &next_block_best_position, &next_block_best_orientation);
      }

      if(trial_merit > current_best_merit)
      {
        current_best_merit = trial_merit;
        current_best_position = trial_position;
        current_best_orientation = trial_orientation;
      }
    }
  }

  *best_position = current_best_position;
  *best_orientation  = current_best_orientation;

  return current_best_merit;
}

/*

float Strategy(FIELD field, int block, int orientation, int *bestPosition, int *bestOrientation)
{
  FIELD tmpField;
  int rotation = 0;
  int minx, maxx;
  int currentBestPosition = 0;
  int currentBestOrientation = 0;
  float currentBestMerit = (-1.0e20f);
  int currentBestPriority = 0;
  int x = 0, y = 0;
  int linesEliminated = 0;

  int trialPosition = 0;
  int trialOrientation = 0;
  float trialMerit = 0.0f;
  int trialPriority = 0;

  if(!field)
    return 0.0;

  for(rotation = 0; rotation < num_rotations_for_blocktype(block); rotation++)
  {
    get_valid_x_positions(block, rotation, &minx, &maxx);
    for(x = minx; x <= maxx; x++)
    {
      memcpy(tmpField, field, TC_FIELD_SIZE);
      set_current_block(block, rotation, x, y);
      tetris_blockdrop(tmpField);
      tetris_solidify(tmpField);

      linesEliminated = tetris_removelines(NULL, tmpField);
      trialMerit = (float)tetris_total_shadowed_holes(tmpField) * g_shadowedHolesWeight;
      trialMerit += (float)tetris_pile_height_weighted_cells(tmpField) * g_pileHeightWeight;
      trialMerit += (float)tetris_sum_of_well_heights(tmpField) * g_sumOfWellHeightsWeight;
  
			printf("setting up switch: %d\n", setting_up_switch);
      if(setting_up_switch)
      {
        trialMerit = -trialMerit;
      }  
//      printf("trial merit inner = %f\n", trialMerit);
      if((trialMerit > currentBestMerit) || ((trialMerit == currentBestMerit) && (trialPriority > currentBestPriority)))
      {
        currentBestPriority = trialPriority;
        currentBestMerit = trialMerit;
        currentBestPosition = x;//trialPosition;
        currentBestOrientation = rotation;//trialOrientation;
      }
    }
  }

  *bestPosition = currentBestPosition;
  *bestOrientation = currentBestOrientation;
  return currentBestMerit;
}


float StrategyNextBlock(FIELD field, int block, int orientation, int nextBlock, int nextOrientation, int *bestPosition, int *bestOrientation)
{
  FIELD tmpField;
  int rotation;
  int minx, maxx;
  int x = 0, y = 0;
  int currentBestPosition = 0;
  int currentBestOrientation = 0;
  float currentBestMerit = (-1.0e20f);
  int currentBestPriority = 0;

  int trialPosition = 0;
  int trialOrientation = 0;
  float trialMerit = 0.0f;
  int trialPriority = 0;

  int nextBlockBestPosition;
  int nextBlockBestOrientation;

  for(rotation = 0; rotation < num_rotations_for_blocktype(block); rotation++)
  {
    get_valid_x_positions(block, rotation, &minx, &maxx);
    for(x = minx; x <= maxx; x++)
    { 
      memcpy(tmpField, field, TC_FIELD_SIZE);
      set_current_block(block, rotation, x, y);
      tetris_blockdrop(tmpField);
      tetris_solidify(tmpField);

      trialMerit = Strategy(tmpField, nextBlock, nextOrientation, &nextBlockBestPosition, &nextBlockBestOrientation);

      //printf("trial merit = %f pos = %d ori = %d \n", trialMerit, x, rotation);
   
      if( (trialMerit > currentBestMerit) || ((trialMerit == currentBestMerit) && (trialPriority > currentBestPriority)) )
      {
        currentBestPriority = trialPriority;
        currentBestMerit = trialMerit;
        currentBestPosition = x;
        currentBestOrientation = rotation;
// 				printf("Currently best: priority: %d, merit: %f, possition: %d, orient: %d\n", trialPriority, trialMerit, currentBestPosition, currentBestOrientation);
      }
    }
  }

  *bestPosition = currentBestPosition;
  *bestOrientation = currentBestOrientation;
 printf("best pozzie: %d, best orrie: %d\n", currentBestPosition, currentBestOrientation);
  return currentBestMerit;
}
*/



/*
int GetBestMove(int block, int xpos, int ypos, int orientation, FIELD field, int *best_position, int *best_orientation, int recurse, int best_value)
{
  int next_block;
  int next_orientation;

  int rnb;
  GetNextBlock(&rnb);
  TranslateToLocalRep(rnb, &next_block, &next_orientation);
  StrategyNextBlock(field, block, orientation, next_block, next_orientation, best_position, best_orientation);
  return 1;
}
*/

