/*
 *  Copyright (C) 2003 Chris Yeoh (cyeoh@samba.org)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   /Speciathe Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <termios.h>

#include "tclient.h"
#include "btetris.h"
#include "useless.h"
#include "getMove.h"
#include "player.h"

struct TC_GameData *gdata;
char *Specials = NULL;
int status = 0;
int setting_up_switch = 0;
int g_own_player_number = 0;
extern int g_set_up_gravity_tetris;

struct FieldParams
{
int block_bomb_num_blocks;
int field_merit;
};

void TranslateToLocalRep(int blocktype, int *lblock, int *orientation);

void getOwnSpecials(char *specials, int *ownSpecials) 
{
  int i;
int j;
  for (i=0; i<9; i++) {
		ownSpecials[i] = 0;
  }
  for (i=0; specials[i] != 0; i++) {
	  ownSpecials[specials[i]-TC_SPECIAL_FIRST_SPECIAL]++;
	}
}

void PrintSpecials(char *specials)
{
  int i;
  printf("Specials are: ");
  for(i = 0; specials[i] != 0; i++)
  {
    switch(specials[i])
    {
      case TC_SPECIAL_CLEAR_LINE:
        printf("c");
        break;
      case TC_SPECIAL_BLOCK_GRAVITY:
        printf("g");
        break;
      case TC_SPECIAL_NUKE:
        printf("n");
        break;
      case TC_SPECIAL_SWITCH_FIELDS:
        printf("s");
        break;
      case TC_SPECIAL_ADD_LINE:
        printf("a");
        break;
      case TC_SPECIAL_BLOCK_BOMB:
        printf("o");
        break;
      case TC_SPECIAL_CLEAR_RANDOM:
        printf("r");
        break;
      case TC_SPECIAL_CLEAR_SPECIALS:
        printf("b");
        break;
      case TC_SPECIAL_BLOCK_QUAKE:
        printf("q");
        break;
    }
  }
  printf(" -- \n");
}

void PrintField(FIELD field)
{
#ifdef DEBUG
	int i,j;
	char display;

	printf("\n");
	for (i=0; i<TC_FIELD_HEIGHT; i++)
	{
		for (j=0; j<TC_FIELD_WIDTH; j++)
		{
			display = field[i][j];
			display += 48;
			printf("%c", display);
		}
		printf("\n");
	}
#endif
}

void TranslateToLocalRep(int blocktype, int *lblock, int *orientation)
{
	switch (blocktype)
	{
	case TC_BLOCK_I_1:
		*lblock = 0;
		*orientation = 0;
		return;
		
	case TC_BLOCK_I_2:
		*lblock = 0;
		*orientation = 1;
		return;

	case TC_BLOCK_O:
		*lblock = 1;
		*orientation = 0;
		return;

	case TC_BLOCK_J_1:
		*lblock = 2;
		*orientation = 3;
		return;

	case TC_BLOCK_J_2:
		*lblock = 2;
		*orientation = 2;
		return;

	case TC_BLOCK_J_3:
		*lblock = 2;
		*orientation = 1;
		return;

	case TC_BLOCK_J_4:
		*lblock = 2;
		*orientation = 0;
		return;

	case TC_BLOCK_L_1:
		*lblock = 3;
		*orientation = 1;
		return;

	case TC_BLOCK_L_2:
		*lblock = 3;
		*orientation = 0;
		return;

	case TC_BLOCK_L_3:
		*lblock = 3;
		*orientation = 3;
		return;

	case TC_BLOCK_L_4:
		*lblock = 3;
		*orientation = 2;
		return;

	case TC_BLOCK_Z_1:
		*lblock = 4;
		*orientation = 1;
		return;

	case TC_BLOCK_Z_2:
		*lblock = 4;
		*orientation = 0;
		return;

	case TC_BLOCK_S_1:
		*lblock = 5;
		*orientation = 1;
		return;

	case TC_BLOCK_S_2:
		*lblock = 5;
		*orientation = 0;
		return;

	case TC_BLOCK_T_1:
		*lblock = 6;
		*orientation = 3;
		return;

	case TC_BLOCK_T_2:
		*lblock = 6;
		*orientation = 2;
		return;

	case TC_BLOCK_T_3:
		*lblock = 6;
		*orientation = 1;
		return;

	case TC_BLOCK_T_4:
		*lblock = 6;
		*orientation = 0;
		return;

	default:
		printf("oops in translation\n");
		abort();

	}

}



int HasGoodSpecial(int *Specials)
{
	return Specials[TC_SPECIAL_BLOCK_GRAVITY-TC_SPECIAL_FIRST_SPECIAL]
		|| Specials[TC_SPECIAL_NUKE-TC_SPECIAL_FIRST_SPECIAL]
		|| Specials[TC_SPECIAL_SWITCH_FIELDS-TC_SPECIAL_FIRST_SPECIAL];
}

// This function tries to give an attack value to the specials you currently hold
// If you have a good attack_value, you are more likely to throw away your first 
// special in order to get to them
int HasGoodAttackingSpecials(char *specials)
{
		int attack_value = 0;
		int i;
		for (i=0; specials[i]!=0; i++) {
      switch (specials[i])
      {
	      case TC_SPECIAL_ADD_LINE:
					attack_value += 2;
					break;
	      case TC_SPECIAL_CLEAR_SPECIALS:
					attack_value += 2;  //this will depend if they have good specials
					break;
	      case TC_SPECIAL_BLOCK_BOMB:
					attack_value += 3; // this will depend if they have an 'o' on their screen
					break;
	      case TC_SPECIAL_BLOCK_QUAKE:
					attack_value += 2; // this will depend if they are setting up for tetris
					break;
	      case TC_SPECIAL_CLEAR_RANDOM:
					attack_value += 2; // this will depend if they are setting up for tetris
					break;
		}
	}
	return attack_value;
}

// This function is used so that we can check the value of specials on the bottom line
// - we don't want to do a CLEAR_LINE if there are lots of good specials there and our
// field is low
// VAR - the values given to the goodness of each special
int GoodSpecialsOnField(FIELD field, int bottomLineOnly) {	 
	int x, y;
	int specials_value = 0;
  int startAtRow = 0;
  if(bottomLineOnly)
    startAtRow = TC_FIELD_HEIGHT - 1;
  
  for(y = startAtRow; y < TC_FIELD_HEIGHT; y++)
  {
    for (x=0; x<TC_FIELD_WIDTH; x++) {
		  switch (field[y][x]) 
		  {
  		 case TC_SPECIAL_ADD_LINE:
        specials_value += 1;
        break;
       case TC_SPECIAL_CLEAR_SPECIALS:
        specials_value += 2;  //this will depend if they have good specials
        break;
       case TC_SPECIAL_BLOCK_BOMB:
        specials_value += 4;// this will depend if they have an 'o' on their screen
        break;
       case TC_SPECIAL_BLOCK_QUAKE:
        specials_value += 3; // this will depend if they are setting up for tetris
        break;
       case TC_SPECIAL_CLEAR_RANDOM:
		  	specials_value += 2;
			  break;
       case TC_SPECIAL_NUKE:
			  specials_value += 5;
			  break;
       case TC_SPECIAL_BLOCK_GRAVITY:
			  specials_value += 5;
			  break;
       case TC_SPECIAL_SWITCH_FIELDS:
			  specials_value += 4;
			  break;
       case TC_SPECIAL_CLEAR_LINE:
			  specials_value += 1;
			  break;
      }
	  }
	}
  return specials_value;
}

int BoardGravityTetris(FIELD field) {
	
	return 1;
} 

void UseSpecials(FIELD field)
{
  float field_merit;
	int num_holes, field_height;
	char specials[100];
	char tmp_specials[100];
	int i, j, k, try_another_special = 0, changed_field = 0;
	int num_players;
	char *fields[6];
  float field_merits[6];
	int field_specials[6][9];
	int best_field_index = -1;
	float best_field_merit = -2000000;
	int worst_field_index = -1;
	float worst_field_merit = 2000000;
	int use_special_failed;
  struct FieldParams field_params[6];
  struct FieldParams own_field_params;
  int highest_num_blocks;
  int block_bomb_player;
  int ownSpecials[9];
  int break_loop=0;
  float goodSpecialValue = -20000;
  int goodSpecialValueIndex = -1;
	int reread_fields = 1;

	/* Get all own specials */
	GetSpecials(specials);
  //PrintSpecials(specials);

  num_players = GetNumPlayers(gdata);

  UpdatePlayerData();
  int rnb;
	GetNextBlock(&rnb);
	//printf("the next block is %d\n", rnb);
	//printf("num players is: %d\n", num_players);
	if (specials[0])
	{
	  for (i=0; specials[i]!=0; i++)
		{
			if (reread_fields) 
			{
        UpdatePlayerData();
		    printf("num players = %d\n", num_players);
				/* Get Fields for all players */
				for (k=0; k<num_players; k++)
				{
					if (GetPlayerNumber(GetPlayer(gdata,k))==GetOwnPlayerNumber(gdata))
					{
				  	fields[k] = NULL;
				  	field_merits[k] = best_field_merit;
					} else {
						fields[k] = GetField(GetPlayerNumber(GetPlayer(gdata,k)));
						if (fields[k])
						{
       		  	field_merits[k] = FieldMerit(fields[k],NULL);
						} else {
							field_merits[k] = -10000;
						}

						printf("before field merits, current field_merit is %f\n", field_merits[k]);
						if (field_merits[k]>best_field_merit && fields[k]) 
						{
		          best_field_index = k;
           		best_field_merit = field_merits[k];
		        } 

						if (field_merits[k]<worst_field_merit && fields[k]) 
						{
    		    	worst_field_index = k;
	            worst_field_merit = field_merits[k];
   			    }
					}
				}
				reread_fields = 0;
		    field = GetField(GetOwnPlayerNumber(gdata));
			}

			if(field)
			{
			  field_merit = FieldMerit(field, &field_height); //printf("my current field merit is: %f \n", field_merit);
			} 
			else 
			{
				printf("field was null for some reason??? - maybe we won??\n");
				return 1;
			}

			try_another_special = 0;
			getOwnSpecials(specials, ownSpecials);
#ifdef DEBUG
		  for (j=0; j<9; j++) {
				printf("specials: %d \n", ownSpecials[j]);
			} 
#endif          

			switch (specials[i])
			{
				case TC_SPECIAL_CLEAR_LINE:
				/* Clears a single line from the bottom of a field.
					
					Logic: 
					   * If your field is high (>15) and you have no Nukes/Grav/Switch in specials queue, use on self
						 * If your field is low (<7) and you have good specials on bottom line don't use yet 
							 (you're likely to get some new specials soon, so just sit tight!)
						 * If someone else has good Specials on their bottom line and they have a good field 
							 (i.e. they are likely to get the Specials), clear their bottom line
						 * Otherwise - you may as well use it on yourself!
				 */
  	 				if (g_my_player_data->m_field_height > 15 && 
                HasSpecial(g_my_player_data, TC_SPECIAL_NUKE) == 0 &&
                HasSpecial(g_my_player_data, TC_SPECIAL_BLOCK_GRAVITY) == 0 &&
                HasSpecial(g_my_player_data, TC_SPECIAL_SWITCH_FIELDS) == 0)
						{ 
					 		printf("USING A SPECIAL: clear line on self\n");
							use_special_failed = UseSpecial(g_my_player_data->m_player_number);
						  if (use_special_failed) 
							{
								printf("USING A SPECIAL FAILED: clear line \n");
								DiscardSpecial();
							}
						  try_another_special = 1;
							reread_fields = 1;
				  	}	
					  else if ((g_my_player_data->m_field_height < 7) && (GoodSpecialsOnField(g_my_player_data->m_field, 1)>1)) 	// VAR - fsield height 
						{
					  	try_another_special = 0;// don't do anything - we don't want to clear our own specials!
						} 
						else 
 							  // if someone has good specials on their bottom line and they are close to getting it - clear it
						{
          		for(j = 0; j < g_num_players; j++)
	          	{
						  	if((!g_player_data[j].m_player_is_me) && g_player_data[j].m_player_active) 
								{
  	  				  	if (GoodSpecialsOnField(g_player_data[j].m_field ,1)>3 && g_player_data[j].m_field_merit > -8)  
																// VAR - how good is a good field, what value is 'good' specials
					  	    {
										printf("USING A SPECIAL: clear line on someone else who has a good special!\n");
								  	use_special_failed = UseSpecial(g_player_data[j].m_player_number);
						      	if(use_special_failed) 
										{
											printf("USING A SPECIAL FAILED: clear line on someone else\n");
											DiscardSpecial();
										}
									  try_another_special = 1;
										reread_fields = 1;
									  break;
								  }
								}
    	     	}
						if (reread_fields != 1 && field_height > 4) 
						{
					  	printf("USING A SPECIAL: clear line on self\n");
							use_special_failed = UseSpecial(g_my_player_data->m_player_number);
						  if(use_special_failed) {
								printf("USING A SPECIAL FAILED: clear line on self 2 \n");
								DiscardSpecial();
							}
						  try_another_special = 1;
							reread_fields = 1;
						} 
					}
				break;

			case TC_SPECIAL_BLOCK_GRAVITY:
  	 	/* Performs a block gravity - remove all holes from your playfield - drop pieces down.

		 		 Logic: 
					   * If your field is high (>15) use it on yourself
						 * Set up a gravity tetris by setting the g_set_up_gravity_tetris flag
 		   */
				
				if (g_my_player_data->m_field_height > 15) // height > 15 we need to use it!
				{
					printf("USING A SPECIAL: gravity line on self - as field_height > 15\n");
					use_special_failed = UseSpecial(g_my_player_data->m_player_number);
 			    if(use_special_failed) 
					{
						printf("USING A SPECIAL FAILED: clear line failed on self\n");
						DiscardSpecial();
					}
					try_another_special = 1;
					reread_fields = 1;
					g_set_up_gravity_tetris = 0;
				} 
				else if (!g_set_up_gravity_tetris)
				{
					printf("Setting up a gravity tetris!\n");
					g_set_up_gravity_tetris = 1;
				  try_another_special = 0;
				}
				break;
			case TC_SPECIAL_NUKE:
				/* Performs a nuke - removes all pieces from a field.
					
					Logic: 
					   * If your field is high (>15) use it on yourself
				TODO * When to discard it
				 */
				
				if (g_my_player_data->m_field_height>15) 
				{
					printf("USING A SPECIAL: nuke line on self\n");
					use_special_failed = UseSpecial(g_my_player_data->m_player_number);
					if (use_special_failed) {
						printf("USING A SPECIAL FAILED: nuke\n");
						DiscardSpecial();
					}
					try_another_special = 1;
					reread_fields = 1;
				} 
				else 
				{
		  		printf("COULDN'T USE NUKE\n");
					try_another_special = 0;
				}
				break;

			case TC_SPECIAL_SWITCH_FIELDS:
				/* Performs a switch fields - changes your play field with someone elses
					
					Logic: 
					   * If your field is high (>15) AND the best field available is better than your field by X 
							 merit points, switch with the best field.
					   * If your field is high (>15) but the best field available is NOT better than your field 
							 by X merit points - discard it.
						 * If someone has a field better than yours by VAR_SWITCH_THRESHOLD, start trashing your
							 screen in prepartion to switch with them 
				     * Discard the switch when you have better attacking options behind it.
				*/
				printf("field height is %d\n", field_height);
				if (field_height>15)
				{
#ifdef DEBUG
          printf("best field merit = %d, best field index = %d, field_merit = %f\n", best_field_merit, best_field_index, field_merit);
          printf("all fields: ");
          for(j = 0; j < num_players; j++)
          {
            printf("  %f  ",  field_merits[j]);
          }
          printf("\n");
#endif 
					if (best_field_merit-field_merit > 10) // VAR
					{
					  printf("USING A SPECIAL: switch fields on %d\n", best_field_index);
						printf("Before the switch, my field is %f\n", field_merit);
						use_special_failed = UseSpecial(GetPlayerNumber(GetPlayer(gdata,best_field_index)));
						if (use_special_failed) 
						{
							printf("USING A SPECIAL FAILED -switch 1\n");
							DiscardSpecial();
						}
						sleep(1);
						printf("After the switch, my field is %f\n", field_merit);
						g_shadowedHolesWeight = g_shadowedHolesWeight_orig;
            reread_fields = 1;
            setting_up_switch = 0;
            try_another_special = 1;
					} 
				} 
				else 
				{
					// Only set up a switch if another players field is better that our field by at least VAR_SWITCH_THRESHOLD
					printf("best_field_merit was %f, my field_merit was %f\n", best_field_merit, field_merit);
          if (best_field_merit-field_merit>VAR_SWITCH_THRESHOLD ||
						  ownSpecials[TC_SPECIAL_NUKE-TC_SPECIAL_FIRST_SPECIAL] > 0 ||
							ownSpecials[TC_SPECIAL_BLOCK_GRAVITY-TC_SPECIAL_FIRST_SPECIAL] > 0 ) 
					{ 
						printf("Setting a switch - threshold reached or gravity/nuke in queue\n");
						printf("my nukes = %d, my gravs = %d\n", ownSpecials[TC_SPECIAL_NUKE-TC_SPECIAL_FIRST_SPECIAL],  ownSpecials[TC_SPECIAL_BLOCK_GRAVITY-TC_SPECIAL_FIRST_SPECIAL]);
						g_shadowedHolesWeight = -2.0f;
            setting_up_switch = 1;
						try_another_special = 0;
          } 	
					else 
					{
					// Discard a switch if you have no one to switch with and lots of good ATTACKING specials behind it.
        	// If you have Nukes/Gravs then these will only be needed if you have bad height - above
						GetSpecials(tmp_specials);
						printf("Specials attack value =  %d\n", HasGoodAttackingSpecials(tmp_specials)); 
					
						if (HasGoodAttackingSpecials(tmp_specials) > 25)  //VAR - should really be smarter.. ?
																	// only discard a Switch if you have lots of other good stufff
						{
            	printf("Discarding a switch .. as we have attacking specials behind it to the value of %d\n", HasGoodAttackingSpecials(tmp_specials)); 
	            DiscardSpecial();
							try_another_special = 1;
						}
              setting_up_switch = 0;
          }
				}
			break;
			case TC_SPECIAL_CLEAR_SPECIALS:
				/* Clears all special blocks on a field
					
					Logic: 
					   * If your field is high (>15) AND the best field available is better than your field by X AND they have a special
		TODO: choose when to discard it - probably when you have lots of attacking things behind it and they have bad field and you're 1 on 1 ???
			 */
        goodSpecialValue = -20000;
        goodSpecialValueIndex = -1;
				int tmp_specialValue;
				for (j=0; j<num_players; j++)
				{
  				if(fields[j]) 
					{
						tmp_specialValue = GoodSpecialsOnField(fields[j], 0);
            if ((tmp_specialValue*1 + field_merits[j]*1) > goodSpecialValue)  // VAR weight to be determined
				    {
							if (tmp_specialValue != 0)		
							{
						  	goodSpecialValue = tmp_specialValue*1 + field_merits[j]*1; 
					    	goodSpecialValueIndex = j;
							}
				    } 
				  }
        }
				if (goodSpecialValueIndex != -1) 
				{
					printf("USING A SPECIAL: clear specials on (best field) %d, they have goodSpecialValue: %f\n", best_field_index, goodSpecialValue);
					use_special_failed = UseSpecial(GetPlayerNumber(GetPlayer(gdata, goodSpecialValueIndex)));
					if (use_special_failed) {
						printf("USING A SPECIAL FAILED - clear specials\n");
						DiscardSpecial();
					}
		      try_another_special = 1;
				  reread_fields = 1;
				}   
				else 
				{
        		try_another_special = 0;
				}
			break;

			case TC_SPECIAL_ADD_LINE:
				/* Adds a line to the bottom of a field
					
					Logic: 
					   * If you have 0 height screen, use it on yourself so you can get a special quicker
						 * Otherwise use it on the weakest person
				 */
				if (g_my_player_data->m_field_height == 0)  // use it on yourself as you have a blank screen
				{ 
					use_special_failed = UseSpecial(g_my_player_data->m_player_number);
					if (use_special_failed) 
					{
						printf("USING A SPECIAL FAILED - add line on self\n");
						DiscardSpecial();
					}
			 	  printf("USING A SPECIAL: add line on self to get specials\n");
				} 
				else // otherwise use it on the weakest person - ideally they don't have a G,S,N 
				{  
          worst_field_index = g_num_alive_players - 1;
          
          while(HasSpecial(g_player_order[worst_field_index], TC_SPECIAL_NUKE) || 
                HasSpecial(g_player_order[worst_field_index], TC_SPECIAL_BLOCK_GRAVITY) || 
                HasSpecial(g_player_order[worst_field_index], TC_SPECIAL_SWITCH_FIELDS) || 
                g_player_order[worst_field_index]->m_player_is_me)
          {
            worst_field_index--;
            if(worst_field_index == 0)
              break;
          }
           
					use_special_failed = UseSpecial(g_player_order[worst_field_index]->m_player_number);
					printf("USING A SPECIAL: add line on (worst field) %d\n", worst_field_index);
				  if (use_special_failed) 
					{
						printf("USING A SPECIAL FAILED - add line on weakest person\n");
						DiscardSpecial();
					}
				}
				reread_fields = 1;
				try_another_special = 1;
				break;
			case TC_SPECIAL_BLOCK_BOMB:
				/* Throws any blocks near a 'o' around the screen
					
					Logic: 
					   * Find the player with the highest 'blockBombValue' - which is the most blocks around 'o's on 
						   their screen
			TODO   * Logic to discard a block bomb (maybe if we have lots of attacking specials or if we have another 'o' in queue
				 */
        highest_num_blocks = 0;
        block_bomb_player = -1;
				int cur_num_blocks;
				for (j=0; j<num_players; j++)
				{        
					cur_num_blocks = GetBlockBombValue(fields[j]);
					printf("for this player(j=%d) block_bomb_num_blocks is %d\n", j,cur_num_blocks);
          if (cur_num_blocks >= highest_num_blocks && j != g_own_player_number)
          {
            highest_num_blocks = cur_num_blocks;
            block_bomb_player = j;
          }          
				}

				printf("the highest num blocks is: %d the player is %d\n", highest_num_blocks,block_bomb_player);
        if(highest_num_blocks > 0)
        {
					printf("using BLOCK BOMB NOW on %d!\n", block_bomb_player);
          use_special_failed = UseSpecial(GetPlayerNumber(GetPlayer(gdata, block_bomb_player)));
					if (use_special_failed) {
						printf("using BLOCK BOMB FAILED :: %d", use_special_failed);
					  DiscardSpecial();
					}
					reread_fields = 1;
          try_another_special = 1;
        } 
				break;

			case TC_SPECIAL_CLEAR_RANDOM:
			case TC_SPECIAL_BLOCK_QUAKE:
				/* Clears random blocks on a field

					 Logic:
							Use on people with good density and big wells
				 */
			  printf("USING A SPECIAL: clear random or block quake on best field: %d\n", best_field_index);
				use_special_failed = UseSpecial(GetPlayerNumber(GetPlayer(gdata, best_field_index)));
				if (use_special_failed) {
					printf("Failed to use CLEAR_RANDOM\n");	
					DiscardSpecial();
				}
				try_another_special = 1;
				break;
			}

			/* Have this test here as a failsafe to make sure we exit
				 if the game is over */
			{
				int dummy1, dummy2, dummy3;
				if (GetCurrentBlock(&dummy1, &dummy2, &dummy3)) break;
			}
			if (!try_another_special || use_special_failed) break;
		}
		/* Take evasive maneouvres - don't worry too much about attacking! */
	  GetSpecials(specials);
		getOwnSpecials(specials, ownSpecials);

	  if (field_height>15 && 
			  (ownSpecials[TC_SPECIAL_NUKE-TC_SPECIAL_FIRST_SPECIAL] || 
				 ownSpecials[TC_SPECIAL_BLOCK_GRAVITY-TC_SPECIAL_FIRST_SPECIAL] )) {
			printf("Taking evasive action !!! \n");
			use_special_failed = 0;
			for (i=0; specials[i] != 0; i++) {
			  switch(specials[i]) 
        {
				 case TC_SPECIAL_CLEAR_LINE:
					 use_special_failed = UseSpecial(GetOwnPlayerNumber(gdata));
					 break;
				 case TC_SPECIAL_ADD_LINE:
				 case TC_SPECIAL_BLOCK_QUAKE:
				 case TC_SPECIAL_CLEAR_RANDOM:
				 case TC_SPECIAL_CLEAR_SPECIALS:
				 case TC_SPECIAL_BLOCK_BOMB:
					 printf("Dumping %d on %d\n", specials[i], GetPlayerNumber(GetPlayer(gdata, best_field_index)));
				   use_special_failed = UseSpecial(GetPlayerNumber(GetPlayer(gdata, best_field_index)));
					 break;
				 case TC_SPECIAL_SWITCH_FIELDS:
					 printf("Switching with %d\n", GetPlayerNumber(GetPlayer(gdata, best_field_index)));
				   use_special_failed = UseSpecial(GetPlayerNumber(GetPlayer(gdata, best_field_index)));
           setting_up_switch = 0;
					 break_loop = 1;
					 break;
				 case TC_SPECIAL_BLOCK_GRAVITY:
				 case TC_SPECIAL_NUKE:
					 printf("Nuking/Grav'ing\n");
					 use_special_failed = UseSpecial(GetOwnPlayerNumber(gdata));
					 break_loop = 1;
					 break;
			 }
			 if (use_special_failed) {
				 printf("USE SPECIAL FAIELD IN EVASIVE \n");
				 DiscardSpecial();
			 }
				if (break_loop==1) {
					break_loop=0;
				  break;
		 		}
		 } //end for
	 } // end if
  }

}

int main(int argc, char *argv[])
{
	char *username = "useless";
	char *field;
	int blocktype, xpos, ypos;
	int localblocktype, orientation;
	int use_offset, use_orientation;

	int i, status;

  int blocks[2];
  int orientations[2];


	if (argc>1)
	{
		username = argv[1];
	}

	if (connectToServer("localhost", 9467, username, "", "")<0)
	{
		printf("error: %s\n", tc_error_string);
		exit(1);
	}
	else
	{
		printf("success\n");
	}

	while (1)
	{
		printf("Waiting for game start\n");
   setting_up_switch = 0;
		if (Start(&gdata) != 0)
		{
			printf("Game start failed\n");
			exit(1);
		}
		else
		{
			printf("Game starting\n");
		}
    InitPlayerData(gdata);


    g_own_player_number = GetOwnPlayerNumber(gdata);
		printf("my player number is %d\n", g_own_player_number);

		while (1)
		{
			status = GetCurrentBlock(&blocktype, &xpos, &ypos);
		
			if (status==1)
			{
				printf("*** We lost! ***\n");
				printf("========================================================\n");
				break;
			}
			else if (status==2)
			{
				printf("========================================================\n");
				printf("*** We won! ***\n");
				break;
			}

			if (blocktype==TC_BLOCK_NONE) 
			{
				/* This is being CPU greedy! - it won't sleep */
				//usleep(200000);
			  //usleep(5000);
				field = GetField(GetOwnPlayerNumber(gdata));
				if (!field) 
				{
				  break;
				}
				UseSpecials(field);
				continue;
			}
			else
			{
				printf("--------------------------------------------------\n");
				printf("Got block %i\n", blocktype);

			}
			// next two lines just for debug - print out specials
			char tmp_specials[100];
			GetSpecials(tmp_specials);
  		PrintSpecials(tmp_specials);

			field = GetField(GetOwnPlayerNumber(gdata));

//			printf("************************Have field\n");
			PrintField(field);
			TranslateToLocalRep(blocktype, &(blocks[0]), &(orientations[0]));
      GetNextBlock(&blocktype);
      TranslateToLocalRep(blocktype, &(blocks[1]), &(orientations[1]));

			if ( ((blocks[0] == TC_BLOCK_I_1) || (blocks[0] == TC_BLOCK_I_2)) &&
					 g_set_up_gravity_tetris) {
				int tmp_field_height;
				int tmp_field_merit = FieldMerit(field, &tmp_field_height);
				if (tmp_field_height > 10) {
	   			int use_special_failed = UseSpecial(GetOwnPlayerNumber(gdata));
					printf("USING SPECIAL: Gravity..in main loop!!\n");
					if (use_special_failed) {
						printf("Use grav failed?? - discarding\n");
						DiscardSpecial();
					}
				  g_set_up_gravity_tetris = 0;
				}
			}
				 
      GetBestMove(blocks, 2, field, &use_offset, &use_orientation);

//			GetBestMove(localblocktype, xpos, ypos, orientation, field, &use_offset,
//									&use_orientation, 0, -20000);

			printf("**** Think best position is %i and orientation is %i\n",
						 use_offset, use_orientation);
			printf("**** Current position %i and orientation is %i\n",
						 xpos, orientation);

      orientation = orientations[0];

			for (i=orientation; i!=use_orientation; 
					 orientation<use_orientation ? i++ : i--)
			{
				MoveBlock(orientation<use_orientation ? TC_ROTATE_CLOCKWISE
									: TC_ROTATE_ANTICLOCKWISE);
			}
			for (i=xpos; i!=use_offset; xpos<use_offset ? i++ : i--)
			{
				MoveBlock(xpos<use_offset ? TC_MOVE_RIGHT : TC_MOVE_LEFT);
			}
			MoveBlock(TC_MOVE_DROP);

			/* Specials on self? */
			UseSpecials(field);
		}
    CleanUpPlayerData();
	}	

		exit(0);
}
