/*
 *  Many parts taken from GTetrinet
 *  Copyright (C) 1999, 2000, 2001, 2002, 2003  Ka-shu Wong (kswong@zip.com.au)
 *  Copyright (C) 2003 Chris Yeoh (cyeoh@samba.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "client.h"
#include "tetrinet.h"
#include "tetris.h"
#include "log.h"

TETRISBLOCK b1[2] = {
    {
        {1,1,1,1},
        {0,0,0,0},
        {0,0,0,0},
        {0,0,0,0}
    }, {
        {0,0,1,0},
        {0,0,1,0},
        {0,0,1,0},
        {0,0,1,0}
    }
};

TETRISBLOCK b2[1] = {
    {
        {0,2,2,0},
        {0,2,2,0},
        {0,0,0,0},
        {0,0,0,0}
    }
};

TETRISBLOCK b3[4] = {
    {
        {0,0,3,0},
        {0,0,3,0},
        {0,3,3,0},
        {0,0,0,0}
    }, {
        {0,3,0,0},
        {0,3,3,3},
        {0,0,0,0},
        {0,0,0,0}
    }, {
        {0,3,3,0},
        {0,3,0,0},
        {0,3,0,0},
        {0,0,0,0}
    }, {
        {0,3,3,3},
        {0,0,0,3},
        {0,0,0,0},
        {0,0,0,0}
    }
};

TETRISBLOCK b4[4] = {
    {
        {0,4,0,0},
        {0,4,0,0},
        {0,4,4,0},
        {0,0,0,0}
    }, {
        {0,4,4,4},
        {0,4,0,0},
        {0,0,0,0},
        {0,0,0,0}
    }, {
        {0,4,4,0},
        {0,0,4,0},
        {0,0,4,0},
        {0,0,0,0}
    }, {
        {0,0,0,4},
        {0,4,4,4},
        {0,0,0,0},
        {0,0,0,0}
    }
};


TETRISBLOCK b5[2] = {
    {
        {0,0,5,0},
        {0,5,5,0},
        {0,5,0,0},
        {0,0,0,0}
    }, {
        {0,5,5,0},
        {0,0,5,5},
        {0,0,0,0},
        {0,0,0,0}
    }
};

TETRISBLOCK b6[2] = {
    {
        {0,1,0,0},
        {0,1,1,0},
        {0,0,1,0},
        {0,0,0,0}
    }, {
        {0,0,1,1},
        {0,1,1,0},
        {0,0,0,0},
        {0,0,0,0}
    }
};
TETRISBLOCK b7[4] = {
    {
        {0,0,2,0},
        {0,2,2,0},
        {0,0,2,0},
        {0,0,0,0}
    }, {
        {0,0,2,0},
        {0,2,2,2},
        {0,0,0,0},
        {0,0,0,0}
    }, {
        {0,2,0,0},
        {0,2,2,0},
        {0,2,0,0},
        {0,0,0,0}
    }, {
        {0,2,2,2},
        {0,0,2,0},
        {0,0,0,0},
        {0,0,0,0}
    }
};
static TETRISBLOCK *blocks[7] = { b1, b2, b3, b4, b5, b6, b7 };
static int blockcount[7] = { 2, 1, 4, 4, 2, 2, 4 };

static int blocknum = -1, blockorient; /* which block */
static int blockx, blocky; /* current location of block */

static int pendingblocknum = -1, pendingblockorient;
static char *current_specials = NULL;
static int max_num_specials = 0;
static int blockfrequencies[7];
static int specialfrequencies[9];
static int player_state[6];

static int blockobstructed (FIELD field, int block, int orient, int bx, int by);
static int obstructed (FIELD field, int x, int y);
static void placeblock (FIELD field, int block, int orient, int bx, int by);

/* returns a random number in the range 0 to n-1 --
 * Note both n==0 and n==1 always return 0 */
int randomnum (int n)
{
    return (float)n*rand()/(RAND_MAX+1.0);
}


/* void tetris_drawcurrentblock (void) */
/* { */
/*     FIELD field; */
/*     copyfield (field, fields[playernum]); */
/*     if (blocknum >= 0) */
/*         placeblock (field, blocknum, blockorient, blockx, blocky); */
/*     fields_drawfield (playerfield(playernum), field); */
/* } */

/* returns a random block */
static int tetrinet_getrandomblock (void)
{
    int i = 0, n = randomnum (100);
    while (n >= blockfrequencies[i]) i ++;
    return i;
}

int tetris_makeblock(int block, int orient, FIELD field)
{
	blocknum = block;
	blockorient = orient;
	blockx = FIELD_WIDTH/2-2;
	blocky = 0;

	if (block >= 0 &&
			blockobstructed(field, blocknum, blockorient, blockx, blocky))
	{
		/* player is dead */
/* 		tetrinet_playerlost (); */
		blocknum = -1;
		return 1;
	}
	else
		return 0;
}

int tetris_randomorient (int block)
{
    return randomnum (blockcount[block]);
}

P_TETRISBLOCK tetris_getblock (int block, int orient)
{
    return blocks[block][orient];
}

/* returns -1 if block solidifies, 0 otherwise */
int tetris_blockdown (FIELD field)
{
/* 	printf("block %i pos %i %i\n", blocknum, blockx, blocky); */
    if (blocknum < 0) return 0;
    /* move the block down one */
    if (blockobstructed (field, blocknum, blockorient, blockx, blocky+1))
    {
        /* cant move down */
#ifdef DEBUG
			printf ("blockobstructed: %d %d\n", blockx, blocky);
#endif
			return -1;
    }
    else 
		{
			blocky ++;
			return 0;
    }
}

int tetris_blockmove (int dir, FIELD field)
{
	if (blocknum < 0) return -1;
	if (blockobstructed(field, blocknum,  blockorient, blockx+dir, blocky))
	{
    /* do nothing */;
		return -1;
	}
	else
	{
    blockx += dir;
		return 0;
	}
}

int tetris_blockrotate (int dir, FIELD field)
{
	int neworient = blockorient + dir;
	if (blocknum < 0) return -1;
	if (neworient >= blockcount[blocknum]) neworient = 0;
	if (neworient < 0) neworient = blockcount[blocknum] - 1;
	switch (blockobstructed(field, blocknum, neworient, blockx, blocky))
	{
	case 1: return -1; /* cant rotate if obstructed by blocks */
	case 2: /* obstructed by sides - move block away if possible */
	{
		int shifts[4] = {1, -1, 2, -2};
		int i;
		for (i = 0; i < 4; i ++) {
			if (!blockobstructed (field, blocknum,
														neworient, blockx+shifts[i],
														blocky))
			{
				blockx += shifts[i];
				goto end;
			}
		}
		return -1; /* unsuccessful */
	}
	}
end:
	blockorient = neworient;
	return 0;
}

void tetris_blockdrop (FIELD field)
{
	if (blocknum < 0) return;
	while (tetris_blockdown(field) == 0);
}

/* this function removes full lines */
int tetris_removelines (char *specials, FIELD field)
{
    int x, y, o, c = 0, i;

    /* remove full lines */
    for (y = 0; y < FIELD_HEIGHT; y ++) {
        o = 0;
        /* count holes */
        for (x = 0; x < FIELD_WIDTH; x ++)
            if (field[y][x] == 0) o ++;
        if (o) continue; /* if holes */
        /* no holes */
        /* increment line count */
        c ++;
        /* grab specials */
        if (specials)
            for (x = 0; x < FIELD_WIDTH; x ++)
                if (field[y][x] > 5)
								{
									*specials++ = field[y][x];
								}
        /* move field down */
        for (i = y-1; i >= 0; i --)
            for (x = 0; x < FIELD_WIDTH; x ++)
                field[i+1][x] = field[i][x];
        /* clear top line */
        for (x = 0; x < FIELD_WIDTH; x ++)
            field[0][x] = 0;
    }
    if (specials) *specials = 0; /* null terminate */
    return c;
}

int tetris_addlines(int numlines, FIELD field, int type)
{
	int x, y, i;

	for (i = 0; i < numlines; i ++) {
		/* check top row */
		for (x = 0; x < FIELD_WIDTH; x ++) {
			if (field[0][x]) {
				/* player is dead */
				return 1;
			}
		}
		/* move everything up one */
		for (y = 0; y < FIELD_HEIGHT-1; y ++) {
			for (x = 0; x < FIELD_WIDTH; x ++)
				field[y][x] = field[y+1][x];
		}
		if (type==2)
		{
			/* generate a random line with spaces in it */
			for (x = 0; x < FIELD_WIDTH; x ++)
				field[FIELD_HEIGHT-1][x] = randomnum(5) + 1;
			/* add a single space */
			field[FIELD_HEIGHT-1][randomnum(FIELD_WIDTH)] = 0;
		}
		else
		{
			/* Original add line for tetrinet - used for normal adds */
			for (x = 0; x < FIELD_WIDTH; x ++)
				field[FIELD_HEIGHT-1][x] = randomnum(6);
			field[FIELD_HEIGHT-1][randomnum(FIELD_WIDTH)] = 0;
		}
	}
	return 0;
}

void tetris_clearline(FIELD field)
{
	int x,y;
	for (y = FIELD_HEIGHT-1; y > 0; y --)
		for (x = 0; x < FIELD_WIDTH; x ++)
			field[y][x] = field[y-1][x];
	for (x = 0; x < FIELD_WIDTH; x ++) field[0][x] = 0;
}

void tetris_clear_random(FIELD field)
{
	int i;
	for (i=0; i<10; i++)
	{
		field[randomnum(FIELD_HEIGHT)][randomnum(FIELD_WIDTH)] = 0;
	}
}

void tetris_clear_specials(FIELD field)
{
	int x, y;
	for (y = 0; y < FIELD_HEIGHT; y ++)
		for (x = 0; x < FIELD_WIDTH; x ++)
			if (field[y][x] > 5) field[y][x] = randomnum (5) + 1;
}

void tetris_block_gravity(FIELD field)
{
	int x, y, i;
	for (y = 0; y < FIELD_HEIGHT; y ++)
		for (x = 0; x < FIELD_WIDTH; x ++)
			if (field[y][x] == 0) {
				/* move the above blocks down */
				for (i = y; i > 0; i --)
					field[i][x] = field[i-1][x];
				field[0][x] = 0;
			}

}

void tetrinet_shiftline(int line, int shift, FIELD field)
{
	int i;
	if (shift > 0) { /* to the right */
		for (i = FIELD_WIDTH-1; i >= shift; i --)
			field[line][i] = field[line][i-shift];
		for (; i >= 0; i --) field[line][i] = 0;
	}
	if (shift < 0) { /* to the left */
		for (i = 0; i < FIELD_WIDTH-shift; i ++)
			field[line][i] = field[line][i-shift];
		for (; i < FIELD_WIDTH; i ++) field[line][i] = 0;
	}
	/* if shiftd == 0 do nothing */
}

void tetris_block_quake(FIELD field)
{
	int i, y;
	for (y = 0; y < FIELD_HEIGHT; y ++) {
		/* [ the original approximation of blockquake frequencies were
			 not quite correct ] */
		/* ### This is a much better approximation and probably how the */
		/* ### original tetrinet does it */
		int s = 0;
		i = randomnum (22);
		if (i < 1) s ++;
		if (i < 4) s ++;
		if (i < 11) s ++;
		if (randomnum(2)) s = -s;
		tetrinet_shiftline (y, s, field);
		/* ### Corrected by Pihvi */
	}

}

extern void tetris_block_bomb(FIELD field)
{
	int ax[] = {-1, 0, 1, 1, 1, 0, -1, -1};
	int ay[] = {-1, -1, -1, 0, 1, 1, 1, 0};
	int c = 0;
	int x, y, i;
	char block;
	char buf[512];

	/* find all bomb blocks */
	for (y = 0; y < FIELD_HEIGHT; y ++)
		for (x = 0; x < FIELD_WIDTH; x ++)
			if (field[y][x] == 14) {
				/* remove the bomb */
				field[y][x] = 0;
				/* grab the squares around it */
				for (i = 0; i < 8; i ++) {
					if (y+ay[i] >= FIELD_HEIGHT || y+ay[i] < 0 ||
							x+ax[i] >= FIELD_WIDTH || x+ax[i] < 0) continue;
					block = field[y+ay[i]][x+ax[i]];
					if (block == 14) block = 0;
					else field[y+ay[i]][x+ax[i]] = 0;
					buf[c] = block;
					c ++;
				}
			}
	/* scatter blocks */
	for (i = 0; i < c; i ++)
		field[randomnum(FIELD_HEIGHT-6)+6][randomnum(FIELD_WIDTH)] = buf[i];
}

static void switch_half(FIELD original, FIELD destination)
{
	int x, y, need_to_move;

	/* may overlap - eg be the same */
	memmove(destination, original, FIELD_WIDTH*FIELD_HEIGHT);

	/* Check to see if we should move the field down */
	for (y = 0; y < 6; y ++)
		for (x = 0; x < FIELD_WIDTH; x ++)
			if (destination[y][x]) goto done;

done:
	need_to_move = 6 - y;

	if (need_to_move)
	{
		/* need to move field down i lines */
		for (y = FIELD_HEIGHT-1; y >= need_to_move; y --)
			for (x = 0; x < FIELD_WIDTH; x ++)
				destination[y][x] = destination[y-need_to_move][x];
		for (y = 0; y < need_to_move; y ++)
			for (x = 0; x < FIELD_WIDTH; x ++) destination[y][x] = 0;
	}
}

void tetris_switch_fields(FIELD original, FIELD destination)
{
	FIELD tmp_field;
	memcpy(tmp_field, original, FIELD_WIDTH*FIELD_HEIGHT);

	switch_half(destination, original);
	switch_half(tmp_field, destination);
}


int tetris_solidify (FIELD field)
{
    if (blocknum < 0) return 0;
    if (blockobstructed (field, blocknum, blockorient, blockx, blocky)) {
        /* move block up until we get a free spot */
        for (blocky --; blocky >= 0; blocky --)
            if (!blockobstructed (field, blocknum, blockorient, blockx, blocky))
            {
                placeblock (field, blocknum, blockorient, blockx, blocky);
                break;
            }
        if (blocky < 0) {
            /* no space - player has lost */
            blocknum = -1;
            return -1;
        }
    }
    else {
        placeblock (field, blocknum, blockorient, blockx, blocky);
    }
    blocknum = -1;
		return 0;
}

static int blockobstructed (FIELD field, int block, int orient, int bx, int by)
{
    int x, y, side = 0;
    for (y = 0; y < 4; y ++)
        for (x = 0; x < 4; x ++)
            if (blocks[block][orient][y][x]) {
                switch (obstructed (field, bx+x, by+y)) {
                case 0: continue;
                case 1: return 1;
                case 2: side = 2;
                }
            }
    return side;
}

static int obstructed (FIELD field, int x, int y)
{
    if (x < 0) return 2;
    if (x >= FIELD_WIDTH) return 2;
    if (y < 0) return 1;
    if (y >= FIELD_HEIGHT) return 1;
    if (field[y][x]) return 1;
    return 0;
}

static void placeblock (FIELD field, int block, int orient, int bx, int by)
{
    int x, y;
    for (y = 0; y < 4; y ++)
        for (x = 0; x < 4; x ++) {
            if (blocks[block][orient][y][x])
                field[y+by][x+bx] = blocks[block][orient][y][x];
        }
}

int get_current_block()
{
	return blocknum;
}

int get_current_orient()
{
	return blockorient;
}

void get_current_block_position(int *x, int *y)
{
	*x = blockx;
	*y = blocky;
}

void tetris_make_pending_block()
{
	pendingblocknum = tetrinet_getrandomblock();
	pendingblockorient = tetris_randomorient(pendingblocknum);
/* 	pendingblocknum = 0; */
/* 	pendingblockorient = 0; */
}

int tetris_pending_block(void)
{
	return pendingblocknum;
}

int tetris_pending_block_orient(void)
{
	return pendingblockorient;
}

void tetris_set_block_frequencies(int block_frequencies[7])
{
/* 	int i=0; */
	memcpy(blockfrequencies, block_frequencies, sizeof(int)*7);

/* 	for (i=0; i<8; i++) */
/* 	{ */
/* 		printf("freq for block %i is %i\n", i, blockfrequencies[i]); */
/* 	} */
}

void tetris_set_block_special_frequencies(int block_frequencies[9])
{
	memcpy(specialfrequencies, block_frequencies, sizeof(int)*9);
}

/* adds random special block to the field */
void tetrinet_addsbtofield (int count, FIELD field)
{
	int s, n, c, x, y, i, j;
	char sb;

	for (i = 0; i < count; i ++) {
		/* get a random special block */
		s = 0;
		n = randomnum(100);
		while (n >= specialfrequencies[s]) s ++;
		sb = 6 + s;
		/* sb is the special block that we want */
		/* count the number of non-special blocks on the field */
		c = 0;
		for (y = 0; y < FIELD_HEIGHT; y ++)
			for (x = 0; x < FIELD_WIDTH; x ++)
				if (field[y][x] > 0 && field[y][x] < 6) c ++;
		if (c == 0) { /* drop block */
			/* i *think* this is how it works in the original -
				 blocks are not dropped on existing specials,
				 and it tries again to find another spot...
				 this is because... when a large number of
				 blocks are dropped, usually all columns get 1 block
				 but sometimes a column or two doesnt get a block */
			for (j = 0; j < 20; j ++) {
				n = randomnum (FIELD_WIDTH);
				for (y = 0; y < FIELD_HEIGHT; y ++)
					if (field[y][n]) break;
				if (y == FIELD_HEIGHT || field[y][n] < 6) break;
			}
			if (j == 20) goto end;
			y --;
			field[y][n] = sb;
		}
		else { /* choose a random location */
			n = randomnum (c);
			for (y = 0; y < FIELD_HEIGHT; y ++)
				for (x = 0; x < FIELD_WIDTH; x ++)
					if (field[y][x] > 0 && field[y][x] < 6) {
						if (n == 0) {
							field[y][x] = sb;
							goto next;
						}
						n --;
					}
		next:
			/* fall through */ ;
		}
	}
end:
}

void tetris_set_num_specials(int Max)
{
	current_specials = realloc(current_specials, Max+1);
	current_specials[0] = 0;
	max_num_specials = Max;
}

void tetris_add_special(char Special)
{
	int position, i;
	int numspecials = strlen(current_specials);

	if (strlen(current_specials) >= max_num_specials)
	{
		/* Specials buffer full */
		return;
	}

	position = randomnum(numspecials);

	for (i=numspecials; i>position; i--)
	{
		current_specials[i] = current_specials[i-1];
	}
	current_specials[position] = Special;
	current_specials[numspecials+1] = 0;
}

void tetris_delete_first_special(void)
{
	int numSpecials, i;

	numSpecials = strlen(current_specials);
	for (i=0; i<numSpecials-1; i++)
	{
		current_specials[i] = current_specials[i+1];
	}
	current_specials[i] = 0;
}
char *tetris_get_specials(void)
{
	return current_specials;
}

void tetris_clear_all_specials(void)
{
	current_specials[0] = 0;
}

void tetris_set_player_state(int playernum, int state)
{
	if (playernum>6||playernum<0)
	{
		printf("Fatal: playernum not between 0 and 6\n");
		abort();
	}
	player_state[playernum] = state;
}

void tetris_set_all_players_alive()
{
	memset(player_state, 0, sizeof(int)*6);
}

int tetris_get_player_state(int playernum)
{
	return player_state[playernum];
}

void tetris_create_dead_field(FIELD field)
{
	int x,y;

	for (y=0; y<FIELD_HEIGHT; y++)
	{
		for (x=0; x<FIELD_WIDTH; x++)
		{
			field[y][x] = randomnum(5) + 1;
		}
	}
}
