#ifndef __BTETRIS_H
#define __BTETRIS_H

/* Copied from gtetrinet code base 
 * Adds following copyright notice 
 *  Copyright (C) 1999, 2000, 2001, 2002, 2003  Ka-shu Wong (kswong@zip.com.au)
 */

#include "tclient.h"

#define FIELD_WIDTH TC_FIELD_WIDTH
#define FIELD_HEIGHT TC_FIELD_HEIGHT

typedef char TETRISBLOCK[4][4];
typedef char (*P_TETRISBLOCK)[4];
typedef char FIELD[FIELD_HEIGHT][FIELD_WIDTH];


extern int tetris_randomorient (int block);


extern P_TETRISBLOCK tetris_getblock (int block, int orient);

/* Move block down one place */
extern int tetris_blockdown (FIELD field);
/* returns -1 if block solidifies, 0 otherwise */

/* Move block */
extern int tetris_blockmove (int dir, FIELD field);
/* returns -1 if block obstructed, 0 otherwise */

/* Rotate block */
extern int tetris_blockrotate (int dir, FIELD field);
/* returns -1 if block obstructed, 0 otherwise */

extern void tetris_blockdrop (FIELD field);

extern int tetris_solidify (FIELD field);
/* returns -1 if player died, 0 otherwise */

extern int tetris_removelines (char *specials, FIELD field);
/* How big is the special array meant to be? */
/* Returns number of lines removed */

extern int tetris_addlines(int numlines, FIELD field);
/* Returns 1 if player died, 0 otherwise */

extern void tetris_clearline(FIELD field);

extern void tetris_clear_random(FIELD field);

extern void tetris_clear_specials(FIELD field);

extern void tetris_block_gravity(FIELD field);

extern void tetris_block_quake(FIELD field);

extern void tetris_block_bomb(FIELD field);

extern void tetris_switch_fields(FIELD destination, FIELD original);


// extern void copyfield (FIELD dest, FIELD src);

/* Current falling block */
int get_current_block(void);
int get_current_orient(void);
void get_current_block_position(int *x, int *y);

void set_current_block(int block, int orientation, int x, int y);

int num_rotations_for_blocktype(int block);

void get_valid_x_positions(int block, int orientation, int *minx, int *maxx);
int get_orientation_after_rotation(int block, int orientation, int rotation);

int blockobstructed (FIELD field, int block, int orient, int bx, int by);

#endif
