-- Lua bot implementation

-- function find_best_move(field, cfg_spaces, potential, localblocktype,
--                         xpos, ypos, orientation)

-- end

function handle_block(blocktype, xpos, ypos)
    -- Get current field
    field = get_field(get_own_player_number())
    if is_dead_field(field) then
        return false
    end

    localblocktype, orientation = translate_to_local_rep(blocktype)

    -- Translate to configuration spaces
    -- cfg_spaces[i] where i is the rotation which generates the
    -- configuration space.
    -- FIXME: This should be cached where possible
--    cfg_spaces, potential = get_configuration_spaces(field, localblocktype, ypos)

    -- Use A* algorithm to search the configuration spaces to the best
    -- move. Impossible moves will automatically be removed from the
    -- configuration spaces.
--     moves = find_best_move(field, cfg_spaces, potential, localblocktype,
--                            xpos, ypos, orientation)
--
--     i = 1
--     while moves[i] ~= nil do
--         move_block(moves[i])
--         i++
--     done
--
--     use_specials(field)
--
--     return 1

    -- Find moves best move
    use_offset, use_orientation = get_best_move(localblocktype, xpos, ypos,
                                                orientation, field)

    -- Rotate piece
    while orientation ~= use_orientation do
        if orientation < use_orientation then
            orientation = orientation + 1
            move_block(tc.TC_ROTATE_CLOCKWISE)
        else
            orientation = orientation - 1
            move_block(tc.TC_ROTATE_ANTICLOCKWISE)
        end
    end

    -- Move piece
    while xpos ~= use_offset do
        if xpos < use_offset then
            xpos = xpos + 1
            move_block(tc.TC_MOVE_RIGHT)
        else
            xpos = xpos - 1
            move_block(tc.TC_MOVE_LEFT)
        end
    end
    move_block(tc.TC_MOVE_DROP)

    -- Use specials
    use_specials(field)

    return 1
end

function play_game()
    status, blocktype, xpos, ypos = get_current_block()

    if status == 1 then
        dprint("Game lost.\n")
        return false
    elseif status == 2 then
        dprint("Game won\n")
        return false
    end

    if blocktype == tc.TC_BLOCK_NONE then
        usleep(100000)
    else
        alive = handle_block(blocktype, xpos, ypos)
        if not alive then
            return false
        end
    end

    return 1
end

bot_connect("xorl")

-- Note: It is possible to rewrite or replace the bot part way through
-- a game. This makes it possible to quickly fix bugs as they are noticed.
in_game = nil
while check_bot_change() do
    if not in_game then
        wait_start()
    end

    in_game = play_game()
end

dprint("Exiting.\n")

-- vim:et sw=4 ts=4
