/* possible gestures that we can make with one hand */
enum Gesture {
  GST_NOTHING,
  GST_KNIFE,
  GST_FINGER,
  GST_PALM,
  GST_SNAP,
  GST_WAVE,
  GST_POINT,      /* aka. digit */
  GST_CLAP,
  GST_ANTISPELL,
  GST_FOG,
  GST_FINAL_MARKER,
  GST_MASK = 15
};

/* convert the Gesture enum into a printable character */
extern char gesture_print[16];

/* a pair of gestures:
 * - left gesture in the MSB nybble
 * - right gesture in the LSB nybble
 */
typedef unsigned char GesturePair;

/* given a left and right gesture, make a GesturePair
 * (also works with a GestureList)
 */
#define make_gp(a, b) (((long long)(a) << 4) | (long long)(b))

/* swap the hands around of a Gesture or GestureList */
#define swap_hands(a) (make_gp(RH(a), LH(a)))

/* extract only the left or right hands from a GesturePair or GestureList */
#define LH_MASK (long long)0xF0F0F0F0F0F0F0F0
#define RH_MASK (long long)0x0F0F0F0F0F0F0F0F
#define LH(a) (((a) & LH_MASK) >> 4)
#define RH(a) ((a) & RH_MASK)

/* a list of gesture pairs (8 at most as that's the longest spell) */
typedef unsigned long long GestureList;

/* push a GesturePair onto a GestureList */
#define gl_push(a, b) (((a) << 8) | (b))

/* Possible (reasonable) gesture pairs that we might want to make are
 * enumerated in poss_gp[].  They are the following in any
 * combination on left and right hands except for either GST_KNIFE
 * with both hands or GST_PALM with both hands:
 *   GST_KNIFE
 *   GST_FINGER
 *   GST_PALM
 *   GST_SNAP
 *   GST_WAVE
 *   GST_POINT
 * (makes 6*6-2 = 34)
 * Plus GST_CLAP with both hands (GST_CLAP in only one hand is the
 * same as GST_NOTHING).
 * The last element in poss_gp is set to 0 (GST_NOTHING, GST_NOTHING)
 * to indicate the end of the list (we don't want to play that
 * GesturePair anyway).
 */
#define MAX_POSS_GP 35

extern GesturePair poss_gp[MAX_POSS_GP + 1];

/* Same as poss_gp, but don't list the same gesture with swapped hands
 * (used for the initial move).
 */
#define MAX_POSS_GP_NOSWAP 20
extern GesturePair poss_gp_noswap[MAX_POSS_GP_NOSWAP + 1];

/* Same as poss_gp, but with GST_CLAP and GST_NOTHING in all
 * combinations (used when a hand is paralysed).
 */
#define MAX_POSS_GP_PARA 61
extern GesturePair poss_gp_para[MAX_POSS_GP_PARA + 1];

/* Same as poss_gp, but without GST_PALM.
 */
#define MAX_POSS_GP_CONFUSED 24
extern GesturePair poss_gp_confused[MAX_POSS_GP_CONFUSED + 1];

void print_gesture_list(GestureList gl);
void init_gestures(void);
