#!/usr/bin/env python2.3

# vim: set shiftwidth=4 tabstop=4 expandtab smartindent textwidth=80:

# Part of ecar, an entry for the LCA 2005 hackfest:
# http://lca2005.linux.org.au/hackfest/
# (C) 2005, Russell Steicke, <russells@adelie.cx>
# Licensed under GPL, see the file COPYING.


# Make us faster, if available.
try:
    import psyco
    psyco.full()
except ImportError, reason:
    pass
import sys
import gtk

from hflib.Monster import Monster
from hflib.protocol import *


class ScMonster(Monster):
    def __init__(self, type, name):
        Monster.__init__(self, type, name)
        typename = self.getTypeName()
        if typename[0] in 'aeiouAEIOU':
            self.wholename = "%s (an %s)" % (name, typename)
        else:
            self.wholename = "%s (a %s)" % (name, typename)
        self.widget = gtk.Label(self.wholename)
        self.widget.set_angle(90)

    def getWidget(self):
        return self.widget

    def setHealth(self, health):
        Monster.setHealth(self, health)
        if health <= 0:
            healthText = ", DEAD"
        elif health==1:
            healthText = ", 1 point"
        else:
            healthText = ", %d points" % health
        self.widget.set_text(self.wholename+healthText)

# Local variables: ***
# mode:python ***
# py-indent-offset:4 ***
# fill-column:80 ***
# End: ***
### arch-tag: 1800fe12-8532-4d4a-acbd-2e5b99073d7b
