#!/usr/bin/env python2.3

# vim: set shiftwidth=4 tabstop=4 expandtab smartindent textwidth=80:

# Part of ecar, an entry for the LCA 2005 hackfest:
# http://lca2005.linux.org.au/hackfest/
# (C) 2005, Russell Steicke, <russells@adelie.cx>
# Licensed under GPL, see the file COPYING.


# Make us faster, if available.
try:
    import psyco
    psyco.full()
except ImportError, reason:
    pass

# Local stuff
from hflib.protocol import *
from Creature import Creature

class Monster(Creature):

    def __init__(self, mtype, name):
        Creature.__init__(self, name)
        self.mtype = mtype
        self.owner = 0

    def setOwner(self, owner):
        self.owner = owner

    def getOwner(self):
        return self.owner

    def getType(self):
        return self.mtype

    def getTypeName(self):
        return monsterTypeToName(self.mtype)

    def __str__(self):
        return "<Monster:%s>" % (self.name,)




# Local variables: ***
# mode:python ***
# py-indent-offset:4 ***
# fill-column:80 ***
# End: ***
### arch-tag: d6b26dac-1749-44aa-a296-0e7b9778b720

