#ifndef __SIGNAL_H__
#define __SIGNAL_H__

#include "common.h"
#include <string>
#include <map>


namespace thoth
{
using std::string;
using std::map;

class Agent;
class SignalList;


class Signal
{
public:
    friend class SignalList;
    
        Signal(const string& name) : m_name(name), m_param1(0), m_param2(0)
    {
    } // Signal()

        Signal(const Signal& rhs)
            : m_param1(rhs.m_param1), m_param2(rhs.m_param2),
              m_listeners(rhs.m_listeners)
    {
    } // Signal()


    void set(int param1, int param2)
    {
        m_param1 = param1;
        m_param2 = param2;
    } // set()
    
    void addListener(Agent* agent)
    {
        m_listeners.push_back(agent);
    } // addListener()
    
    void signal(int param1 = 0, int param2 = 0);

    void getValues(int& param1, int& param2)
    {
        param1 = m_param1;
        param2 = m_param2;
    } // getValues()

    const string& getName()
    {
        return m_name;
    } // getName()
    
    
private:
    string          m_name;
    int             m_param1;
    int             m_param2;
    vector<Agent*>  m_listeners;
    
}; // class Signal


class SignalList
{
public:
    
    Signal* getSignal(const string& name);

    void dump();
        
private:
    typedef map<string,Signal*> MapType;

    MapType     m_data;
}; // class SignalList

extern SignalList   SIGNALS;


}; // namespace thoth

#endif /*__SIGNAL_H__*/
