#/**********************************************************************
#	Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
#	
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#**********************************************************************/
#include "RemoteConnection.H"
#include "RingBuffer.H"

#include <assert.h>
#include <errno.h>
#include <netinet/in.h>
#include <signal.h>

connection = None

pending = []
messages = []

def writeMessage(msg):
	if (disabled): 
		return

	s.write(msg)
	const char *messageBuffer = (const char *)MsgToSend;
	int messageBufferSize = MsgToSend->length;

	// Temporarily convert network byte order
	Message::ConvertToNetworkByteOrder(MsgToSend);
	
	s.send(msg.getdata())

buffer = ''
def readData():
	global buffer
	if (disabled): 
		return

	buffer += s.recv()
	if not bytes:
		raise ValueError, 'disconnected'

	while Message.ok(buffer):
		msg, buffer = Message.fromNetwork(buffer)
		messages.append(msg)

#def writeData():
#	if (disabled): 
#		return
#
#	for p in pending:
#		s.send(p.toNetwork())

disabled = true
