#/**********************************************************************
#	Copyright (C) Christopher Yeoh <cyeoh@samba.org> 2005
#	Copyright (C) Stephen Thorne <stephen@thorne.id.au> 2005
#	
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#	
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#	
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#**********************************************************************/

# Hackfest EntryID 87

# I require twisted.
# Please download and install the following python tarballs:
# http://tmrc.mit.edu/mirror/twisted/Twisted/2.0/Twisted-2.0.0.tar.bz2
# http://www.zope.org/Products/ZopeInterface/3.0.1final/ZopeInterface-3.0.1.tgz


from twisted.internet import reactor
from twisted.python import log
from twisted.internet.protocol import Protocol, ClientCreator,\
	ReconnectingClientFactory

import Spells

from sys import stdout
import random
import struct
import time

#{{{

DEFAULT_SPELLCAST_SERVER_PORT = 12701
DEFAULT_SPELLCAST_SERVER_OBSERVER_PORT = 12702
SPELLCAST_PROTOCOL_VERSION = 4

MSG_ASK_WELCOME = 1
MSG_RCV_CLIENT_DETAILS = 2
MSG_ASK_FOR_GESTURES = 3
MSG_RCV_GESTURES_USED = 4
MSG_ASK_FOR_SPELLS_CAST = 5
MSG_RCV_SPELLS_CAST = 6
MSG_SEND_GESTURES_SEEN = 7
MSG_ASK_SPELL_DIRECTIONS = 8
MSG_RCV_SPELL_DIRECTIONS = 9
MSG_SEND_SPELL_CAST = 10
MSG_SEND_CREATURE_STATE = 11
MSG_SEND_END_GAME = 12
MSG_SEND_NEWPLAYER_INFO = 13
MSG_ASK_MONSTER_DIRECTIONS = 15
MSG_RCV_MONSTER_DIRECTIONS = 16
MSG_SEND_NEW_MONSTER_INFO = 17
MSG_SEND_MONSTER_ATTACK_INFO = 18
MSG_SEND_EVENT_INFO = 19
MSG_SEND_START_GAME = 20
MSG_ASK_CHARM_PERSON_CTRL_HAND = 21
MSG_ASK_PARALYSIS_CTRL_HAND = 22
MSG_ASK_CHARM_PERSON_CTRL_GESTURE = 23
MSG_RCV_CHARM_PERSON_CTRL_HAND = 24
MSG_RCV_PARALYSIS_CTRL_HAND = 25
MSG_RCV_CHARM_PERSON_CTRL_GESTURE = 26
MSG_USERNAME_IN_USE_ALREADY = 27
MSG_SEND_ROUND_BEGIN = 28

SC_MONSTER_GOBLIN = 1
SC_MONSTER_OGRE = 2
SC_MONSTER_TROLL = 3
SC_MONSTER_GIANT = 4
SC_MONSTER_FIRE_ELEMENTAL = 5
SC_MONSTER_ICE_ELEMENTAL = 6

SC_EVT_GENERIC_MESSAGE = 1
SC_EVT_ELEMENTAL_MERGE = 2
SC_EVT_ELEMENTAL_CANCEL = 3
SC_EVT_PLAYER_AMNESIA = 4
SC_EVT_CONFUSION = 5
SC_EVT_PLAYER_FEAR = 6
SC_EVT_MONSTER_PARALYSIS = 7
SC_EVT_NO_OWNER_MONSTER_DIES = 8
SC_EVT_PLAYER_DIED = 9
SC_EVT_COUNTER_SPELL_NEGATE = 10
SC_EVT_DISPEL_MAGIC_NEGATE = 11
SC_EVT_DISPEL_MAGIC_DESTROY_MONSTER = 12
SC_EVT_MAGIC_MIRROR_FAIL = 13
SC_EVT_FOD_CANCELS_RAISE_DEAD = 14
SC_EVT_CHARMED_HAND = 15
SC_EVT_PARALYSED_HAND = 16
SC_EVT_CHARMED_GESTURE = 17
SC_EVT_MAGIC_MIRROR_SUCCEED = 18

SC_LEFT_HAND = 1
SC_RIGHT_HAND = 2

CS_DEAD = 1
CS_SHIELD = 1<<1
CS_AMNESIA = 1<<2
CS_PERM_AMNESIA = 1<<3
CS_CONFUSION = 1<<4
CS_PERM_CONFUSION = 1<<5
CS_CHARM_PERSON = 1<<6
CS_PERM_CHARM_PERSON = 1<<7
CS_PARALYSIS = 1<<8
CS_PERM_PARALYSIS = 1<<9
CS_FEAR = 1<<10
CS_PERM_FEAR = 1<<11
CS_ANTI_SPELL = 1<<12
CS_PROT_FROM_EVIL = 1<<13
CS_PERM_PROT_FROM_EVIL = 1<<14
CS_RESIST_HEAT = 1<<15
CS_RESIST_COLD = 1<<16
CS_DISEASED = 1<<17
CS_POISONED = 1<<18
CS_BLINDED = 1<<19
CS_PERM_BLINDED = 1<<20
CS_INVISIBILITY = 1<<21
CS_PERM_INVISIBILITY = 1<<22
CS_HASTE = 1<<23
CS_PERM_HASTE = 1<<24
CS_TIMESTOP = 1<<25
CS_DELAYED_EFFECT = 1<<26
CS_PERMANENCY = 1 << 27
CS_SURRENDER = 1 << 28
#}}}

headerValue = '\xde\xad\xbe\xef'
footerValue = '\xab\xcd\xfe\xda'

def getSpell(name):
	return Spells.rspells[name], iter(Spells.spells[name])

class FireStrategy:
	def __init__(self):
		self.left = self.leftgen()
		self.right = self.rightgen()

	def leftgen(self):
		yield getSpell('FIREBALL')
		while True:
			yield getSpell('FIRESTORM')

	def rightgen(self):
		yield getSpell('RESIST_HEAT')
		while True:
			yield getSpell('CURE_LIGHT_WOUNDS')

class Fire2Strategy(FireStrategy):
	def leftgen(self):
		yield getSpell('FIREBALL')
		while True:
			yield getSpell(random.choice(
								['FIRESTORM', 'FINGER_OF_DEATH', 'LIGHTNING_BOLT']))

class LightStrategy(FireStrategy):
	def leftgen(self):
		while True:
			yield getSpell('LIGHTNING_BOLT')

	def rightgen(self):
		while True: 
			yield getSpell('CURE_HEAVY_WOUNDS')


class ColdStrategy(FireStrategy):
	def leftgen(self):
		yield getSpell('FIREBALL')
		while True:
			yield getSpell('ICESTORM')

	def rightgen(self):
		yield getSpell('RESIST_COLD')
		while True:
				yield getSpell('CURE_LIGHT_WOUNDS')

class Cold2Strategy(ColdStrategy):
	def rightgen(self):
		yield getSpell('RESIST_COLD')
		while True: 
			yield getSpell('CURE_HEAVY_WOUNDS')

class Cold3Strategy(ColdStrategy):
	def rightgen(self):
		yield getSpell('RESIST_COLD')
		while True: 
			yield getSpell('ICESTORM')

class FingerStrategy(FireStrategy):
	def leftgen(self):
		while True:
			yield getSpell('FINGER_OF_DEATH')

	def rightgen(self):
		while True:
			yield getSpell('FIREBALL')

class GiantStrategy(FireStrategy):
	def leftgen(self):
		while True:
			yield getSpell('SUMMON_GIANT')

	def rightgen(self):
		while True:
			yield getSpell('FIREBALL')


class SpellManager:
	def __init__(self):

		self.strat = random.choice([FireStrategy, Fire2Strategy, ColdStrategy,
Cold2Strategy, Cold3Strategy, FingerStrategy, LightStrategy, GiantStrategy])()

		print self.strat.__class__.__name__
		self.p_id, self.p_spell = self.strat.left.next()
		self.s_id, self.s_spell = self.strat.right.next()

	def hands(self):
		try:
			left, right = self.p_spell.next()
		except StopIteration:
			self.p_id, self.p_spell = self.strat.left.next()
			left, right = self.p_spell.next()
			
		if not right:
			try:
				right = self.s_spell.next()[0]
			except StopIteration:
				self.s_id,self.s_spell = self.strat.right.next()
				right = self.s_spell.next()[0]

		return left, right

	def spells(self, vleft, vright):
		left, right = 0, 0
		if self.p_id in vleft:
			left = self.p_id

		if self.s_id in vright:
			right = self.s_id

		return left, right

class Hands(Protocol):
	username = 'Jerub'

	def __init__(self):
                self.round = 0
		self.buf = ''
	
	def dataReceived(self, data):
		self.buf += data
		try:
			while footerValue in self.buf:
				self.process()
		except:
			import traceback
			traceback.print_exc()
			reactor.stop()

	def process(self):
		assert self.buf.startswith(headerValue)
		if footerValue in self.buf:
			payload = self.buf[:self.buf.find(footerValue)+4]
			self.buf = self.buf[self.buf.find(footerValue)+4:]
			
			head, length, command = struct.unpack('!iii', payload[:12])
			message = payload[12:-4]
		
			if command == MSG_ASK_WELCOME:
				data, = struct.unpack('!i', message[:4])
				assert message[-1] == '\0', repr(message)
				message = message[4:-1]
				self.MSG_welcome(data, message)
			elif command == MSG_SEND_START_GAME:
				myid, turntimeout, rounds = struct.unpack(
						'!iii', message[:12])
				self.MSG_start(myid, turntimeout, rounds)
			elif command == MSG_RCV_CLIENT_DETAILS :
				print 'unimplemented', command, repr(message)
			elif command == MSG_ASK_FOR_GESTURES :
				self.MSG_ask_for_gestures()
			elif command == MSG_RCV_GESTURES_USED :
				print 'unimplemented', command, repr(message)
			elif command == MSG_ASK_FOR_SPELLS_CAST :
				length, = struct.unpack('!i', message[:4])
				leftspells = []
				for x in range(length):
					message = message[4:]
					leftspells.append(struct.unpack('!i', message[:4])[0])

				message = message[4:]
				length, = struct.unpack('!i', message[:4])
				rightspells = []
				for x in range(length):
					message = message[4:]

					rightspells.append(struct.unpack('!i', message[:4])[0])
				
				self.MSG_spells_cast(leftspells, rightspells)
			elif command == MSG_RCV_SPELLS_CAST :
				print 'unimplemented', command, repr(message)
			elif command == MSG_SEND_GESTURES_SEEN :
				id, = struct.unpack('!i', message[:4])
				if id == 0:
					self.MSG_got_gestures(self.gestures)
					self.gestures = []
				else:
					id, left, right, anti = struct.unpack('!iiii', message)
					self.gestures.append((id, left, right, anti))
			elif command == MSG_ASK_SPELL_DIRECTIONS :
				left, right, num = struct.unpack('!iii', message[:12])
				validtargets = []
				message = message[12:]
				for x in range(num):
					target, message = self.oneNumber(message)
					validtargets.append(target)
				self.MSG_ask_spell_directions(left, right, validtargets)
			elif command == MSG_RCV_SPELL_DIRECTIONS :
				print 'unimplemented', command, repr(message)
			elif command == MSG_SEND_SPELL_CAST :
				sourcePlayer, = struct.unpack('!i', message[:4])
				if sourcePlayer:
					sourcePlayer, targetCreature, spellCast, worked, more = (
							struct.unpack('!iiiii', message[:20]))
					message = message[20:-1]
					self.MSG_spell_cast(sourcePlayer, targetCreature,
						spellCast, worked, more, message)
			elif command == MSG_SEND_CREATURE_STATE :
				id, = struct.unpack('!i', message[:4])
				if id:
					id, hp, state, prot, disease, poison, blindness, invisibility = struct.unpack(
																				  '!iiiiiiii', message[:4*8])
					self.MSG_creature_state(id, hp, state, prot, disease, poison, blindness, invisibility)
			elif command == MSG_SEND_END_GAME :
				num, = struct.unpack('!i', message[:4])
				winners = []
				for x in range(num):
					message = message[4:]
					winners.append(struct.unpack('!i', message[:4])[0])
				self.MSG_game_over(winners)
			elif command == MSG_SEND_NEWPLAYER_INFO :
				id, other = struct.unpack('!ii', message[:8])
				self.MSG_newplayer(id, message[8:-1])
			elif command == MSG_ASK_MONSTER_DIRECTIONS :
				num, message = self.oneNumber(message)
				monsters = []
				for x in range(num):
					num, message = self.oneNumber(message)
					monsters.append(num)

				num, message = self.oneNumber(message)
				targets = []
				for x in range(num):
					num, message = self.oneNumber(message)
					targets.append(num)

				self.MSG_monsterDirections(monsters, targets)

			elif command == MSG_SEND_NEW_MONSTER_INFO :
				monster_id, monster_type, _, owner_id = struct.unpack('!iiii', message[:16])
				name = message[16:-1]
				self.MSG_new_monster(monster_id, monster_type, owner_id, name)
			elif command == MSG_SEND_MONSTER_ATTACK_INFO :
				self.MSG_monsterAttack(message)
			elif command == MSG_SEND_EVENT_INFO :

				event_type, messageSource, source, target, misc = struct.unpack(
																	'!iiiii', message[:20])
				self.MSG_event(event_type, messageSource, source, target, misc, message[20:])


			elif command == MSG_SEND_START_GAME :
				print 'unimplemented', command, repr(message)
			elif command == MSG_ASK_CHARM_PERSON_CTRL_HAND :
				print 'unimplemented', command, repr(message)
			elif command == MSG_ASK_PARALYSIS_CTRL_HAND :
				print 'unimplemented', command, repr(message)
			elif command == MSG_USERNAME_IN_USE_ALREADY :
				raise ValueError, 'Invalid Username'
			elif command == MSG_SEND_ROUND_BEGIN :
				self.MSG_roundBegin(*struct.unpack('!i', message))
			else:
				print 'unknown', command, repr(message)


	def oneNumber(self, x):
		return struct.unpack('!i', x[:4])[0], x[4:]

	def MSG_new_monster(self, id, type, owner_id, name):
		self.players[id] = name
		self.log('New Monster %s (%d) owned by %s' % (name, id, owner_id))
		if self.id == owner_id:
			self.my_monsters.append(id)
		else:
			self.other_monsters.append(id)

	def MSG_event(self, event_type, messageSource, source, target, misc, message):
		message = message.replace('%T', self.players[target])
		if event_type == 9:
			del self.players[target]
		else:
			print event_type, messageSource, source, target, misc, message
			
		self.log(event_type, message)

	def MSG_ask_for_gestures(self):
		self.do(*self.spellmanager.hands())

	l = ('nothing', 'knife', 'finger', 'palm', 'snap', 'wave', 'point',
		 'clap', 'antispell', 'fog')

	trans = dict([(x, n) for n, x in enumerate(l)])
	names = dict(enumerate(l))
	
	def MSG_monsterAttack(self, msg):
		pass

	def MSG_ask_spell_directions(self, left, right, targets):
		def Hostile(x, me, him):
			if not x:
				return 0
			if Spells.nspells[x] in [
						   'SHIELD', 'MAGIC_MIRROR', 'RESIST_HEAT',
							'RESIST_COLD', 'INVISIBILITY', 'HASTE',
							'TIME_STOP', 'DELAYED_EFFECT', 'PERMANENCY',
							'REMOVE_ENCHANTMENT', 'CURE_LIGHT_WOUNDS',
							'CURE_HEAVY_WOUNDS', 'SUMMON_GOBLIN',
							'SUMMON_OGRE', 'SUMMON_TROLL', 'SUMMON_GIANT',
							'SUMMON_FIRE_ELEMENTAL', 'SUMMON_ICE_ELEMENTAL']:
				return me
			return him

		targets = list(targets)
		try:
			targets.remove(self.id)
			for x in self.my_monsters:
				targets.remove(x)
		except ValueError:
			pass

		lefttarget = Hostile(left, self.id, targets[0])
		righttarget = Hostile(right, self.id, targets[0])
			
		self.reply(MSG_RCV_SPELL_DIRECTIONS, 
				struct.pack('!ii', lefttarget, righttarget))

	def MSG_monsterDirections(self, monsters, targets):
		targets = list(self.players)
		targets.remove(self.id)
		for x in self.my_monsters:
			targets.remove(x)

		payload = struct.pack('!i', len(monsters))

		for x in monsters:
			payload += struct.pack('!i', x)
			payload += struct.pack('!i', targets[0])
		
		self.reply(MSG_RCV_MONSTER_DIRECTIONS, payload)

	def MSG_creature_state(self, id, hp, state, prot, disease, poison,
							blindness, invisibility):

		# swap off things that don't work
		if id != self.id:
			if state & CS_RESIST_HEAT and 'Fire' in \
					self.spellmanager.strat.__class__.__name__:
				self.spellmanager.strat = Cold2Strategy()
			if state & CS_RESIST_COLD and 'Cold' in \
					self.spellmanager.strat.__class__.__name__:
				self.spellmanager.strat = Fire2Strategy()

		self.log(self.players.get(id, 'Dead Player'), 'at', hp, 'hp')

	def MSG_spell_cast(self, sourcePlayer, targetCreature,
					spellCast, worked, more, message):
		self.log(message.replace('%S', self.players.get(sourcePlayer, 'DeadPlayer')
						   ).replace('%T', self.players.get(targetCreature, 'DeadPlayer')))
		#print 'Other:', spellCast, worked, more

	def do(self, left, right):
		if not left: 
			left = 'palm'
			self.defaultleft = Spells.rspells['SHIELD']
		else:
			self.defaultleft = 0
		if not right: 
			left = 'palm'
			self.defaultright = Spells.rspells['SHIELD']
		else:
			self.defaultright = 0

		self.history.append((left, right))
		self.reply(MSG_RCV_GESTURES_USED, 
				struct.pack('!ii', self.trans[left], self.trans[right]))

	def MSG_spells_cast(self, vleft, vright):
		left, right = self.spellmanager.spells(vleft, vright)
		if not left:	left = self.defaultleft
		if not right:	right = self.defaultright
		self.reply(MSG_RCV_SPELLS_CAST, struct.pack('!ii', left, right))
		
	def MSG_game_over(self, winners):
		self.log('Game Over')
		for winner in winners:
			self.log('%s Won' % self.players[winner])

	def MSG_roundBegin(self, round):
		self.round = round

	def MSG_newplayer(self, id, name):
		self.players[id] = name
		self.log('%s (%d) joined' % (name, id))

	def MSG_start(self, id, timeout, rounds):
		self.round = 0
		self.history = []
		self.id = id
		self.timeout = timeout
		self.maxrounds = rounds
		self.players = {}
		self.gestures = []
		self.spellmanager = SpellManager()

		self.my_monsters = []
		self.other_monsters = []

	def log(self, *msg):
		print time.strftime("%Y%m%d %H:%M:%S"), ('[' + str(self.round) + ']'), ' '.join(map(str, msg)).strip()

	def MSG_welcome(self, data, message):
		assert data == SPELLCAST_PROTOCOL_VERSION, (data, SPELLCAST_PROTOCOL_VERSION)

		self.log('Recieved Welcome: %r' % message)

		self.reply(MSG_RCV_CLIENT_DETAILS, self.username+'\0')

	def MSG_got_gestures(self, seq):
		pass
		return
	# Don't say anything
		for id, left, right, anti in seq:
			self.log(self.players[id], self.names[left], self.names[right]) # , anti

	def reply(self, command, message):
		payload = (
				headerValue 
				+ struct.pack('!ii', len(message) + 16, command)
				+ message
				+ footerValue)
		self.transport.write(payload)

class SpellCastClientFactory(ReconnectingClientFactory):
	def buildProtocol(self, addr):
		print 'Connecting ...'
		return Hands()

	def clientConnectionLost(self, connect, reason):
		print 'Connection Lost, Reconnecting'
		return ReconnectingClientFactory.clientConnectionLost(self, connect, reason)

	def clientConnectionFailed(self, connect, reason):
		print 'Connection to', connect.host, connect.port, 'failed'
		reactor.stop()

def main(args):
	hostname, port = 'localhost', 12701
	while len(args):
		if args[0] == '-h':
			args.pop(0)
			hostname = args.pop(0)
		elif args[0] == '-n':
			args.pop(0)
			Hands.username = args.pop(0)
		elif args[0] == '-p':
			args.pop(0)
			port = int(args.pop(0))
		else:
			print 'bad args'
			sys.exit(1)


	f = SpellCastClientFactory()
	reactor.connectTCP(hostname, port, f)
	reactor.run()

if __name__ == '__main__':
	import sys
	main(sys.argv[1:])

# vim: set ts=4 sw=4 noet
